/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.importfile;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreNotifyFileImported;
import de.sillysky.nyssr.impl.file.store.service.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.job.CAbstractJob;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.thread.EThreadPriority;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.time.CUtilInstant;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class CJobImportFile
extends CAbstractJob {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobImportFile.class);
    private static final IId TIMER = CIdFactory.fromObject((Object)"JobImportRetryTimer");
    private static final int MAX_RETRY_COUNT = 10;
    private static final int TIMEOUT = 1000;
    private final IDependencies mDependencies;
    private final Path mSourcePath;
    private final Path mDestinationBasePath;
    private final String mRelativePath;
    private final CTargetAddress mParent;
    private final boolean mRemoveFile;
    private CTimer mTimer;
    private int mRetryCounter = 0;

    public CJobImportFile(@NotNull IDependencies aDependencies, @NotNull Path aSourcePath, @NotNull Path aDestinationBasePath, @NotNull String aRelativePath, @NotNull CTargetAddress aParent, boolean aRemoveFile) {
        this.mDependencies = aDependencies;
        this.mSourcePath = aSourcePath;
        this.mDestinationBasePath = aDestinationBasePath;
        this.mRelativePath = aRelativePath;
        this.mParent = aParent;
        this.mRemoveFile = aRemoveFile;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(TIMER, this::asyncRetry);
    }

    @NotNull
    public EThreadPriority getPriority() {
        return EThreadPriority.LOW;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.tryCopy()) {
            super.notifyJobStopped();
        } else {
            this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER, this.getAddress(), 1000L, false, null);
            this.mTimer.startIf();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRetry(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTimer.notifyTriggerOccurred();
        ++this.mRetryCounter;
        if (this.tryCopy()) {
            super.notifyJobStopped();
        } else if (this.mRetryCounter >= 10) {
            LOG.error("Give up importing file {}", new Object[]{""});
            super.notifyJobStopped();
        } else {
            this.mTimer.startIf();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean tryCopy() throws CException {
        File src = this.mSourcePath.toFile();
        if (!src.exists()) {
            LOG.debug("Couldn't find file {}.", new Object[]{src});
            return true;
        }
        if (!CJobImportFile.canBeAccessed(src.toPath())) {
            LOG.debug("Can't be accessed exclusively: {}.", new Object[]{src});
            return false;
        }
        LOG.trace("Import File {}", new Object[]{this.mSourcePath});
        String hash = CUtilFileStore.calcHash(src);
        FileTime[] timeStamps = CUtilFile.getFileTimes((File)src);
        Instant creationTime = CUtilInstant.fromFileTime((FileTime)timeStamps[0]);
        Instant lastModification = CUtilInstant.fromFileTime((FileTime)timeStamps[1]);
        long length = src.length();
        String newFilename = this.mRelativePath + "._32_" + hash;
        File dest = this.mDestinationBasePath.resolve(newFilename).toFile();
        if (creationTime == null || lastModification == null || hash == null) {
            return false;
        }
        int copyResult = this.copyFile(src, dest);
        if (copyResult != 2) {
            if (this.mRemoveFile) {
                boolean success = src.delete();
                if (success) {
                    File parent = src.getParentFile();
                    this.removeDir(parent);
                } else {
                    LOG.warn("Couldn't remove file {}.", new Object[]{src});
                }
            }
            if (copyResult == 0) {
                CRecord record2 = this.createFileRecord(src, this.mRelativePath, hash, creationTime, lastModification, length);
                this.sendResultToParent(record2);
            }
            return true;
        }
        return false;
    }

    private int copyFile(@NotNull File aSource, @NotNull File aDestination) {
        if (aDestination.exists() && aDestination.length() == aSource.length()) {
            LOG.trace("File already exists. Skip: {}", new Object[]{aSource});
            return 2208;
        }
        File parent = aDestination.getParentFile();
        CUtilFile.createDirectories((File)parent);
        try {
            CUtilFile.copyFile((Path)aSource.toPath(), (Path)aDestination.toPath(), (boolean)true);
            return 0;
        }
        catch (Exception aE) {
            LOG.warn("Exception importing File {}", new Object[]{this.mSourcePath});
            return 2;
        }
    }

    private void sendResultToParent(@NotNull CRecord aRecordFile) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mParent);
        CRecord record = CRecordFileStoreNotifyFileImported.create();
        CRecordFileStoreNotifyFileImported.setFileRecord(record, aRecordFile);
        this.sendNotification(env, record);
    }

    @NotNull
    private CRecord createFileRecord(@NotNull File aSourcePath, @NotNull String aRelativePath, @NotNull String aHash, @NotNull Instant aCreationTime, @NotNull Instant aLastModification, long aFileLength) throws CException {
        String name = aSourcePath.getName();
        LOG.info("+++ Imported:\n    {}\n    {}\n    {}", new Object[]{name, aRelativePath.substring(0, aRelativePath.length() - name.length()), aHash});
        CRecord record = CRecordFileStoreFile.create();
        CRecordFileStoreFile.setPath((CRecord)record, (String)aRelativePath);
        CRecordFileStoreFile.setFileLength((CRecord)record, (long)aFileLength);
        CRecordFileStoreFile.setTimeOfCreation((CRecord)record, (Instant)aCreationTime);
        CRecordFileStoreFile.setTimeOfLastModification((CRecord)record, (Instant)aLastModification);
        CRecordFileStoreFile.setHash((CRecord)record, (String)aHash);
        return record;
    }

    private void removeDir(@NotNull File aDirectory) {
        File dir = aDirectory;
        while (!"incoming".equalsIgnoreCase(dir.getName())) {
            try {
                boolean deleted = dir.delete();
                if (!deleted) {
                    return;
                }
            }
            catch (Exception ignore) {
                return;
            }
            dir = dir.getParentFile();
        }
    }

    @NotNull
    public String getJobName() {
        return "Import-" + this.mSourcePath;
    }

    public static boolean canBeAccessed(@NotNull Path path) {
        boolean bl;
        RandomAccessFile ignored = new RandomAccessFile(path.toFile(), "rw");
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }
}

