/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableContent
implements IRemoteSkinEvent {
    private static final String CELLS = "cells";
    private final List<CEventTableCell> mCells = new ArrayList<CEventTableCell>();

    @Nullable
    public static CEventTableContent create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventTableContent event = new CEventTableContent();
            Object value = jo.getValue(CELLS);
            if (value instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)value;
                for (Object o : arr.getChildren()) {
                    CEventTableCell cell = CEventTableCell.create(o);
                    if (cell == null) continue;
                    event.addCell(cell);
                }
            }
            return event;
        }
        return null;
    }

    @NotNull
    public Collection<CEventTableCell> getCells() {
        return this.mCells;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        CJsonArray arr = new CJsonArray();
        for (CEventTableCell cell : this.mCells) {
            arr.add(cell.toJson());
        }
        jo.put(CELLS, (Object)arr);
        return jo;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CEventTableContent that = (CEventTableContent)aO;
        return this.mCells.equals(that.mCells);
    }

    public int hashCode() {
        return Objects.hash(this.mCells);
    }

    public String toString() {
        return "CDataTableContent{mCells=" + this.mCells + '}';
    }

    public void addCell(CEventTableCell aCell) {
        this.mCells.add(aCell);
    }

    public void addCells(Collection<CEventTableCell> aCells) {
        this.mCells.addAll(aCells);
    }
}

