/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventShowColorChooserDialog
implements IRemoteSkinEvent {
    static final String KEY_MODAL = "modal";
    static final String KEY_TITLE = "title";
    static final String KEY_COLOR = "color";
    static final String KEY_PARENT = "parent";
    private static final boolean DEFAULT_MODAL = false;
    private static final String DEFAULT_TITLE = "Choose a color:";
    private static final CEventColor DEFAULT_COLOR = new CEventColor(Color.white);
    private final boolean mModal;
    private final String mTitle;
    private final CEventColor mColor;
    private final CEventWidgetId mParent;

    public CEventShowColorChooserDialog(boolean aModal, @Nullable String aTitle, @Nullable CEventColor aColor, @NotNull CEventWidgetId aParent) {
        this.mModal = aModal;
        this.mTitle = aTitle == null ? DEFAULT_TITLE : aTitle;
        this.mColor = aColor == null ? DEFAULT_COLOR : aColor;
        this.mParent = aParent;
    }

    @Nullable
    public static CEventShowColorChooserDialog create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CEventWidgetId parent;
            CJsonObject jo = (CJsonObject)aValue;
            boolean modal = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_MODAL, (boolean)false);
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_TITLE, (String)DEFAULT_TITLE);
            CEventColor color = CEventColor.create(jo.getValue(KEY_COLOR));
            if (color == null) {
                color = DEFAULT_COLOR;
            }
            if ((parent = CEventWidgetId.create(jo.getValue(KEY_PARENT))) != null) {
                return new CEventShowColorChooserDialog(modal, title, color, parent);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mModal) {
            jo.put(KEY_MODAL, (Object)true);
        }
        if (CUtilString.isValid((String)this.mTitle)) {
            jo.put(KEY_TITLE, (Object)this.mTitle);
        }
        jo.put(KEY_COLOR, this.mColor.toJson());
        jo.put(KEY_PARENT, this.mParent.toJson());
        return jo;
    }

    public boolean isModal() {
        return this.mModal;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    @NotNull
    public CEventColor getColor() {
        return this.mColor;
    }

    @NotNull
    public CEventWidgetId getParent() {
        return this.mParent;
    }
}

