/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.impl.web.socket.CWebSocketServerTarget;
import de.sillysky.nyssr.impl.web.socket.IDependencies;
import de.sillysky.nyssr.json.IJsonCompactWriter;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplWebSocket
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INamespaceFactory mNamespaceFactory;
    private IJsonParser mJsonParser;
    private IJsonCompactWriter mJsonCompactWriter;
    private IKernelConfiguration mKernelConfiguration;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IJsonParser.class);
        aDependencyList.add(IJsonCompactWriter.class);
        aDependencyList.add(IKernelConfiguration.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mJsonParser = (IJsonParser)aServiceRegistry.getServiceOrThrow(IJsonParser.class);
            this.mJsonCompactWriter = (IJsonCompactWriter)aServiceRegistry.getServiceOrThrow(IJsonCompactWriter.class);
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mService = new CWebSocketServerTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    public IJsonParser getJsonParser() {
        return this.mJsonParser;
    }

    @Override
    public IJsonCompactWriter getJsonCompactWriter() {
        return this.mJsonCompactWriter;
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }
}

