/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.socket.CWebSocketServer;
import de.sillysky.nyssr.impl.web.socket.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CWebSocketServerTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWebSocketServerTarget.class);
    private CWebSocketServer mServer;
    private final IDependencies mDependencies;

    CWebSocketServerTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespaceFactory nf = this.mDependencies.getNamespaceFactory();
        IId nid = CIdFactory.fromObject((Object)"WebSocketServer");
        INamespace ns = nf.createAndRegisterNamespace(nid, "WebSocketServer");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws InterruptedException {
        this.mServer.stop();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mServer = new CWebSocketServer((ITarget)this, this.mDependencies, 8887);
        this.mServer.start();
        LOG.info("WebSocketServer started on port: " + this.mServer.getPort());
        aEnvelope.setResultSuccess();
        return true;
    }
}

