/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.converter.impl.converter.CBooleanArray2ToString;
import de.sillysky.nyssr.converter.impl.converter.CBooleanArrayToString;
import de.sillysky.nyssr.converter.impl.converter.CBooleanToString;
import de.sillysky.nyssr.converter.impl.converter.CByteArrayToString;
import de.sillysky.nyssr.converter.impl.converter.CByteToString;
import de.sillysky.nyssr.converter.impl.converter.CColorToString;
import de.sillysky.nyssr.converter.impl.converter.CDoubleToString;
import de.sillysky.nyssr.converter.impl.converter.CFloatToString;
import de.sillysky.nyssr.converter.impl.converter.CIntegerToString;
import de.sillysky.nyssr.converter.impl.converter.CLongToString;
import de.sillysky.nyssr.converter.impl.converter.CObjectArrayToString;
import de.sillysky.nyssr.converter.impl.converter.CObjectCollectionToString;
import de.sillysky.nyssr.converter.impl.converter.CShortToString;
import de.sillysky.nyssr.converter.impl.converter.CStringToBoolean;
import de.sillysky.nyssr.converter.impl.converter.CStringToBooleanArray;
import de.sillysky.nyssr.converter.impl.converter.CStringToByte;
import de.sillysky.nyssr.converter.impl.converter.CStringToByteArray;
import de.sillysky.nyssr.converter.impl.converter.CStringToCollection;
import de.sillysky.nyssr.converter.impl.converter.CStringToColor;
import de.sillysky.nyssr.converter.impl.converter.CStringToDouble;
import de.sillysky.nyssr.converter.impl.converter.CStringToFloat;
import de.sillysky.nyssr.converter.impl.converter.CStringToInteger;
import de.sillysky.nyssr.converter.impl.converter.CStringToLong;
import de.sillysky.nyssr.converter.impl.converter.CStringToShort;
import de.sillysky.nyssr.converter.impl.converter.CStringToStringArray;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.HashMap;
import java.util.Map;

public final class CConverterRegistry
implements IConverterRegistry {
    private static final String DELIMITER = "#";
    private static final ILogger LOG = CLoggerFactory.getLogger(CConverterRegistry.class);
    private static CConverterRegistry mInstance;
    private final Map<String, IConverter<?, ?>> mRegistry = new HashMap();

    private CConverterRegistry() {
    }

    public static CConverterRegistry getInstance() {
        if (mInstance == null) {
            mInstance = new CConverterRegistry();
            mInstance.activate();
        }
        return mInstance;
    }

    private void activate() {
        this.register(new CBooleanToString());
        this.register(new CStringToBoolean());
        this.register(new CByteToString());
        this.register(new CStringToByte());
        this.register(new CShortToString());
        this.register(new CStringToShort());
        this.register(new CIntegerToString());
        this.register(new CStringToInteger());
        this.register(new CLongToString());
        this.register(new CStringToLong());
        this.register(new CFloatToString());
        this.register(new CStringToFloat());
        this.register(new CDoubleToString());
        this.register(new CStringToDouble());
        this.register(new CColorToString());
        this.register(new CStringToColor());
        this.register(new CBooleanArrayToString());
        this.register(new CBooleanArray2ToString());
        this.register(new CStringToBooleanArray());
        this.register(new CByteArrayToString());
        this.register(new CStringToByteArray());
        this.register(new CObjectArrayToString());
        this.register(new CStringToStringArray());
        this.register(new CStringToCollection());
        this.register(new CObjectCollectionToString());
    }

    @Override
    public <FROM, TO> TO convert(Class<FROM> aSrc, String aSrcType, Class<TO> aDest, String aDestType, FROM aObj, Map<String, Object> aConstraints) {
        LOG.debug("Convert from {}-{} to {}-{}", aSrc.getName(), aSrcType, aDest.getName(), aDestType);
        String key = this.makeConverterKey(aSrc, aSrcType, aDest, aDestType);
        IConverter<?, ?> c = this.mRegistry.get(key);
        if (c != null) {
            return (TO)c.convertTo(aObj, aConstraints);
        }
        LOG.warn("Converter not found: from {} to {}", aSrc.getName(), aDest.getName());
        return null;
    }

    @Override
    public void deregister(IConverter<?, ?> aConverter) {
        String key = this.makeConverterKey(aConverter);
        if (this.mRegistry.remove(key) != null) {
            LOG.info("Converter deregistered: {}", key);
        }
    }

    @Override
    public <FROM, TO> IConverter<FROM, TO> get(Class<FROM> aSrc, String aSrcType, Class<TO> aDest, String aDestType) {
        String key = this.makeConverterKey(aSrc, aSrcType, aDest, aDestType);
        return this.mRegistry.get(key);
    }

    private String makeConverterKey(Class<?> aSrcClass, String aSrcType, Class<?> aDestClass, String aDestType) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(aSrcClass.getName());
        sb.append(DELIMITER);
        sb.append(aSrcType);
        sb.append(DELIMITER);
        sb.append(aDestClass.getName());
        sb.append(DELIMITER);
        sb.append(aDestType);
        return sb.toString();
    }

    private String makeConverterKey(IConverter<?, ?> aConverter) {
        return this.makeConverterKey(aConverter.getSourceClass(), aConverter.getSourceType(), aConverter.getDestinationClass(), aConverter.getDestinationType());
    }

    @Override
    public void register(IConverter<?, ?> aConverter) {
        String key = this.makeConverterKey(aConverter);
        this.mRegistry.put(key, aConverter);
        aConverter.setRegistry(this);
        LOG.info("Converter registered: {}", key);
    }
}

