/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.namespace.CNamespace;
import de.sillysky.nyssr.impl.namespace.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.INamespaceInternal;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import org.jetbrains.annotations.NotNull;

class CNamespaceFactory
implements IService,
INamespaceFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNamespaceFactory.class);
    private final IDependencies mDependencies;

    public CNamespaceFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.registerService(INamespaceFactory.class, this);
    }

    @Override
    @NotNull
    public synchronized INamespace createAndRegisterNamespace(@NotNull IId aNID, @NotNull String aDescription) throws CException {
        if (CIdFactory.isEmpty(aNID)) {
            CException ex = new CException(2502).append("Can't create namespace, NID is invalid.");
            LOG.error(ex.toString());
            throw ex;
        }
        INamespace namespace = this.mDependencies.getNamespaceRegistry().getNamespace(aNID);
        if (namespace != null) {
            LOG.debug("Error: Can't create namespace {} because it already exists.", aNID);
            return namespace;
        }
        LOG.info("Start creating namespace {}", aNID);
        CNamespace ns = new CNamespace(this.mDependencies, aNID, aDescription);
        this.mDependencies.getNamespaceRegistry().registerNamespace(aNID, ns);
        LOG.info("Okay: namespace {} created", aNID);
        return ns;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void deleteNamespace(@NotNull IId aNID) {
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(aNID);
        CUtilCheck.checkNotNull(ns, "Namespace %s not found", aNID.toString());
        this.mDependencies.getNamespaceRegistry().deregisterNamespace(aNID);
        ((INamespaceInternal)((Object)ns)).deactivate();
    }

    @Override
    public INamespace getNamespace(@NotNull IId aNID) {
        return this.mDependencies.getNamespaceRegistry().getNamespace(aNID);
    }
}

