/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.json;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonBase;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.mapper.CValueMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonObject
extends CJsonBase {
    private final LinkedHashMap<String, Object> mMap = new LinkedHashMap();
    private boolean mNormalizedKey = false;

    public CJsonObject() {
    }

    public CJsonObject(boolean aNormalizedKey) {
        this.mNormalizedKey = aNormalizedKey;
    }

    public boolean isNormalizedKey() {
        return this.mNormalizedKey;
    }

    private String makeKey(@NotNull String aKey) {
        if (this.mNormalizedKey) {
            return CUtilNormalize.normalize(aKey);
        }
        return aKey;
    }

    public boolean contains(@NotNull String aKey) {
        String key = this.makeKey(aKey);
        return this.mMap.containsKey(key);
    }

    @Nullable
    public String getKey(int aIndex) {
        return new ArrayList<String>(this.mMap.keySet()).get(aIndex);
    }

    @Nullable
    public Object getValue(int aIndex) {
        String key = this.getKey(aIndex);
        return key == null ? null : this.getValueFromMap(key);
    }

    @Nullable
    public Object getValue(@NotNull String aKey) {
        return this.getValue(aKey, false, null);
    }

    @Nullable
    public Object getValue(@NotNull String aKey, @Nullable Object aDefault) {
        return this.getValue(aKey, false, aDefault);
    }

    @Nullable
    public Object getValue(@NotNull @NotNull String @NotNull [] aKeys, @Nullable Object aDefault) {
        for (String key : aKeys) {
            Object v = this.getValue(key, false, null);
            if (v == null) continue;
            return v;
        }
        return aDefault;
    }

    public Object getValueMapperAware(@NotNull @NotNull String @NotNull [] aKeys, @Nullable Object aDefault) {
        for (String key : aKeys) {
            Object v = this.getValue(key, true, null);
            if (v == null) continue;
            return v;
        }
        return aDefault;
    }

    @Nullable
    public Object getValueMapperAware(@NotNull String aKey) {
        return this.getValue(aKey, true, null);
    }

    @Nullable
    public Object getValueMapperAware(@NotNull String aKey, @Nullable Object aDefault) {
        return this.getValue(aKey, true, aDefault);
    }

    private Object getValue(@NotNull String aKey, boolean aMapperAware, @Nullable Object aDefault) {
        String key = this.makeKey(aKey);
        Object v = this.getValueFromMap(key);
        if (v != null) {
            return v;
        }
        if (aMapperAware && (v = this.getValueFromMap(key = CValueMapper.getIntString(aKey))) != null) {
            return v;
        }
        return aDefault;
    }

    private Object getValueFromMap(@NotNull String aKey) {
        return this.mMap.get(aKey);
    }

    public boolean equals(@Nullable Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CJsonObject that = (CJsonObject)aO;
        return this.mMap.equals(that.mMap) && this.mNormalizedKey == that.mNormalizedKey;
    }

    public int hashCode() {
        return Objects.hash(this.mMap, this.mNormalizedKey);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @NotNull
    public Collection<String> keys() {
        return new ArrayList<String>(this.mMap.keySet());
    }

    public void put(@NotNull String aKey, @Nullable Object aValue) {
        if (this.isEmpty(aValue)) {
            return;
        }
        String key = this.makeKey(aKey);
        this.mMap.put(key, aValue);
    }

    public void putMapperAware(@NotNull String aKey, @Nullable Object aValue) {
        if (this.isEmpty(aValue)) {
            return;
        }
        String key = this.makeKey(aKey);
        key = CValueMapper.getIntString(key);
        this.mMap.put(key, aValue);
    }

    private boolean isEmpty(@Nullable Object aValue) {
        if (aValue == null) {
            return true;
        }
        if (aValue instanceof String) {
            String value = (String)aValue;
            return value.isEmpty();
        }
        return false;
    }

    @Nullable
    public Object remove(@NotNull String aKey) {
        String key = this.makeKey(aKey);
        return this.mMap.remove(key);
    }

    public int size() {
        return this.mMap.size();
    }

    @NotNull
    public CJsonObject getCopy() {
        CJsonObject jo = new CJsonObject(this.isNormalizedKey());
        for (Map.Entry<String, Object> entry : this.mMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof CJsonObject) {
                jo.put(key, ((CJsonObject)value).getCopy());
                continue;
            }
            if (value instanceof CJsonArray) {
                jo.put(key, ((CJsonArray)value).getCopy());
                continue;
            }
            jo.put(key, value);
        }
        return jo;
    }

    public void clear() {
        this.mMap.clear();
    }
}

