/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.json;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.stream.CUtilStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class CUtilJson {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilJson.class);

    private CUtilJson() {
    }

    @NotNull
    public static String loadJson(@NotNull Class<?> aParent, @NotNull String aPath) throws CException {
        String string;
        block8: {
            InputStream stream = aParent.getResourceAsStream(aPath);
            try {
                String json;
                byte[] bytes = CUtilStream.readByteArrayFully(stream);
                string = json = new String(bytes, StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Error on loading JSON file {}", aPath);
                    throw new CException(2).append(e);
                }
            }
            stream.close();
        }
        return string;
    }
}

