/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordRegisterTarget
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("1685ebe1-b0e4-4560-a3ec-98e8b3968f3f");
    public static final String NAME = "RegisterTarget";
    public static final String DESCRIPTION = "Register a target asynchronously.";
    public static final String SLOT_ADDRESS = "adr";
    public static final String SLOT_NAME = "name";
    public static final String SLOT_NAMESPACE_ID = "nid";
    public static final String SLOT_TARGET = "tgt";
    public static final String SLOT_TID_WANTED = "tid";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getNamespaceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAMESPACE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static Object getTarget(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGET);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static IId getTidWanted(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TID_WANTED);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_ADDRESS, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setNamespaceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NAMESPACE_ID, slot);
    }

    public static void setTarget(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.OBJECT, aValue);
        aRecord.addSlot(SLOT_TARGET, slot);
    }

    public static void setTidWanted(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_TID_WANTED, slot);
    }
}

