/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilUuid {
    public static final UUID UUID_INVALID = new UUID(0L, 0L);
    private static final int SIG_POS30 = 30;
    private static final String UUID_REGEX = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    private static final Pattern UUID_REGEX_PATTERN = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");

    private CUtilUuid() {
    }

    public static int compare(@NotNull UUID aUuid1, @NotNull UUID aUuid2) {
        long v2;
        long v1 = aUuid1.getMostSignificantBits();
        int result = Long.compare(v1, v2 = aUuid2.getMostSignificantBits());
        if (result == 0) {
            v1 = aUuid1.getLeastSignificantBits();
            v2 = aUuid2.getLeastSignificantBits();
            result = Long.compare(v1, v2);
        }
        return result;
    }

    @Nullable
    public static UUID fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (valid) {
            return CUtilUuid.nonNullFromStream(aStream);
        }
        return null;
    }

    @NotNull
    public static UUID fromString(@Nullable String aValue) {
        if (CUtilString.isValid(aValue) && UUID_REGEX_PATTERN.matcher(aValue).matches()) {
            try {
                return UUID.fromString(aValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return UUID_INVALID;
    }

    @NotNull
    public static UUID nonNullFromStream(@NotNull DataInput aStream) throws IOException {
        long least = aStream.readLong();
        long most = aStream.readLong();
        return new UUID(most, least);
    }

    @NotNull
    public static UUID random() {
        return UUID.randomUUID();
    }

    public static boolean equals(@Nullable Object aToken1, @Nullable Object aToken2) {
        if (aToken1 == null || aToken2 == null) {
            return aToken1 == aToken2;
        }
        return aToken1.equals(aToken2);
    }

    public static boolean isEmpty(@Nullable UUID aID) {
        return aID == null || aID == UUID_INVALID || UUID_INVALID.equals(aID);
    }

    public static boolean isValid(@Nullable UUID aID) {
        return aID != null && aID != UUID_INVALID && !UUID_INVALID.equals(aID);
    }

    public static void nonNullToStream(@NotNull DataOutput aOut, @NotNull UUID aID) throws IOException {
        aOut.writeLong(aID.getLeastSignificantBits());
        aOut.writeLong(aID.getMostSignificantBits());
    }

    @NotNull
    public static String toShortString(@Nullable UUID aValue) {
        return aValue == null ? "null" : aValue.toString().substring(30);
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable UUID aID) throws IOException {
        if (aID == null || UUID_INVALID.equals(aID)) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CUtilUuid.nonNullToStream(aStream, aID);
        }
    }

    @NotNull
    public static String toString(@Nullable UUID aValue) {
        if (CUtilUuid.isEmpty(aValue)) {
            return "";
        }
        return aValue.toString();
    }

    @NotNull
    public static UUID fromUuid(@Nullable UUID aUuid) {
        return aUuid == null ? UUID_INVALID : aUuid;
    }

    @Nullable
    public static UUID fromObject(@Nullable Object aValue) {
        if (aValue instanceof UUID) {
            return (UUID)aValue;
        }
        if (aValue instanceof String) {
            String s = (String)aValue;
            if ("null".equalsIgnoreCase(s)) {
                return null;
            }
            return CUtilUuid.fromString(s);
        }
        return null;
    }
}

