/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.util.hash.CAbstractHash;
import de.sillysky.nyssr.util.hash.EHashType;
import de.sillysky.nyssr.util.hash.IDigest;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CHashUnknown
extends CAbstractHash
implements IDigest {
    public CHashUnknown(EHashType aType, byte[] aDigest) {
        super(aDigest == null ? EHashType.EMPTY : aType, aDigest, "?");
    }

    @Override
    public void digest() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getByteArrayWithHeader() {
        int streamedLength = this.getStreamedLength();
        try (ByteArrayOutputStream s = new ByteArrayOutputStream(streamedLength);){
            byte[] byArray;
            try (DataOutputStream d = new DataOutputStream(s);){
                this.toStream(d);
                d.close();
                byArray = s.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getDigestLength() {
        byte[] hash = super.getHash();
        return hash == null ? 0 : hash.length;
    }

    @Override
    public void setDigest(byte[] aDigest) {
    }

    @Override
    public void update(byte[] aData, int aPosition, int aLength) {
    }

    @Override
    public String valueToString() {
        return this.toString();
    }
}

