/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingTextComponent;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventHtml;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingEditorPane
extends CSwingTextComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingEditorPane.class);

    CSwingEditorPane(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("html", this::applyHtml);
    }

    private boolean applyHtml(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        CEventHtml event = CEventHtml.create((Object)aValue);
        if (event != null && (component = this.getComponent()) instanceof JEditorPane) {
            JEditorPane pane = (JEditorPane)component;
            LOG.debug("Set Html");
            pane.setBorder(null);
            HTMLEditorKit eKit = new HTMLEditorKit();
            pane.setContentType("text/html");
            pane.setEditorKit(eKit);
            pane.putClientProperty("JEditorPane.honorDisplayProperties", true);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(new Font("Noto Serif", 0, 14));
            pane.setText(event.getHtml());
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.EditorPane.name();
    }
}

