/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.registry;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileEntry {
    @NotNull
    private final String mPath;
    @Nullable
    private final String mHash;
    @NotNull
    private final Instant mTimeOfLastModification;
    @NotNull
    private final CTargetAddress mSourceTarget;

    CFileEntry(@NotNull String aPath, @Nullable String aHash, @NotNull Instant aTimeOfLastModification, @NotNull CTargetAddress aSourceTarget) {
        this.mPath = CUtilPath.normalizeSlashesInPath((String)aPath);
        this.mHash = aHash;
        this.mTimeOfLastModification = aTimeOfLastModification;
        this.mSourceTarget = aSourceTarget;
    }

    boolean isPathEqual(@NotNull String aPath) {
        return aPath.equals(this.mPath);
    }

    boolean isTimeEqualOrNewer(@NotNull Instant aTimeOfLastModification) {
        return aTimeOfLastModification.equals(this.mTimeOfLastModification) || aTimeOfLastModification.isAfter(this.mTimeOfLastModification);
    }

    boolean isTimeEqual(@NotNull Instant aTimeOfLastModification) {
        return this.mTimeOfLastModification.equals(aTimeOfLastModification);
    }

    boolean isHashEqual(@NotNull String aHash) {
        return this.mHash != null && this.mHash.equals(aHash);
    }

    public boolean isHashAndTimeEqual(String aHash, Instant aTimeOfLastModification) {
        return this.mHash != null && this.mHash.equals(aHash) && this.mTimeOfLastModification.equals(aTimeOfLastModification);
    }

    @NotNull
    CTargetAddress getSourceTarget() {
        return this.mSourceTarget;
    }

    @NotNull
    public String getPath() {
        return this.mPath;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CFileEntry that = (CFileEntry)aObject;
        if (!this.mPath.equals(that.mPath)) {
            return false;
        }
        if (!Objects.equals(this.mHash, that.mHash)) {
            return false;
        }
        if (!this.mTimeOfLastModification.equals(that.mTimeOfLastModification)) {
            return false;
        }
        return this.mSourceTarget.equals((Object)that.mSourceTarget);
    }

    public int hashCode() {
        int result = this.mPath.hashCode();
        result = 31 * result + (this.mHash != null ? this.mHash.hashCode() : 0);
        result = 31 * result + this.mTimeOfLastModification.hashCode();
        result = 31 * result + this.mSourceTarget.hashCode();
        return result;
    }

    public Instant getTimeOfLastModification() {
        return this.mTimeOfLastModification;
    }

    @Nullable
    String getHash() {
        return this.mHash;
    }
}

