/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilIcon;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.util.CIconHandler;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EIconUsage;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalTextPosition;
import de.sillysky.nyssr.remoteskin.model.events.CEventMnemonic;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalTextPosition;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingLabel
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingLabel.class);
    private final JLabel mComponent = new JLabel();
    private final CIconHandler mIconHandler = new CIconHandler(this){

        @Override
        public void setIcon(@NotNull Icon aIcon, EIconUsage aUsage) {
            JLabel label = CSwingLabel.this.getComponent();
            switch (aUsage) {
                case disabled: {
                    label.setDisabledIcon(aIcon);
                    break;
                }
                case enabled: {
                    label.setIcon(aIcon);
                }
            }
        }
    };
    private Object mLabelFor = null;

    CSwingLabel(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("horizontalAlignment", this::applyHorizontalAlignment);
        list.addHandler("horizontalTextPosition", this::applyHorizontalTextPosition);
        list.addHandler("icon", this::applyIcon);
        list.addHandler("icons", this::applyIcons);
        list.addHandler("iconTextGap", this::applyIconTextGap);
        list.addHandler("labelFor", this::applyLabelFor);
        list.addHandler("mnemonic", this::applyMnemonic);
        list.addHandler("text", this::applyText);
        list.addHandler("verticalAlignment", this::applyVerticalAlignment);
        list.addHandler("verticalTextPosition", this::applyVerticalTextPosition);
        list.addHandler("widthInCharacters", this::applyWidthInCharacters);
        list.addHandler("iconColor", this::applyIconColor);
    }

    @NotNull
    public JLabel getComponent() {
        return this.mComponent;
    }

    private boolean applyIconColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            Icon icon = this.mComponent.getIcon();
            if (icon != null) {
                ImageIcon invertedIcon = CUtilIcon.changeColor((ImageIcon)icon, event.createColor());
                this.mComponent.setIcon(invertedIcon);
            }
            return true;
        }
        return false;
    }

    private boolean applyIconTextGap(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int gap = CUtilInteger.fromObject((Object)aValue, (int)0);
            this.getComponent().setIconTextGap(gap);
            return true;
        }
        return false;
    }

    private boolean applyLabelFor(@NotNull String aKey, @Nullable Object aValue) {
        this.mLabelFor = aValue;
        return true;
    }

    private boolean applyHorizontalAlignment(@NotNull String aKey, @Nullable Object aValue) {
        CEventHorizontalAlignment event = CEventHorizontalAlignment.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getHorizontalAlignment()});
            this.getComponent().setHorizontalAlignment(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyHorizontalTextPosition(@NotNull String aKey, @Nullable Object aValue) {
        CEventHorizontalTextPosition event = CEventHorizontalTextPosition.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getHorizontalTextPosition()});
            this.getComponent().setHorizontalTextPosition(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue, EIconUsage.enabled);
    }

    private boolean applyIcons(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvents(aValue);
    }

    private void applyLabelFor(@NotNull Object aValue) {
        try {
            CWidget widget = CUtilReference.parseReference((CWidget)this, (Object)aValue);
            if (widget == null) {
                LOG.error("LabelFor: Couldn't find widget {}", new Object[]{aValue});
            } else {
                this.getComponent().setLabelFor(widget.getComponent());
            }
        }
        catch (Exception aE) {
            LOG.error("LabelFor: Exception on find widget {}", new Object[]{aValue});
        }
    }

    private boolean applyMnemonic(@NotNull String aKey, @Nullable Object aValue) {
        CEventMnemonic event = CEventMnemonic.create((Object)aValue);
        if (event != null) {
            int swingConstant = event.getSwingConstant();
            if (swingConstant >= 0) {
                this.getComponent().setDisplayedMnemonic(swingConstant);
            } else {
                char character = event.getCharacter();
                if (character != '\u0000') {
                    this.getComponent().setDisplayedMnemonic(character);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyText(@NotNull String aKey, @Nullable Object aValue) {
        CEventText event = CEventText.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set Text to {}", new Object[]{aValue});
            this.getComponent().setText(event.getText());
            return true;
        }
        return false;
    }

    private boolean applyVerticalAlignment(@NotNull String aKey, @Nullable Object aValue) {
        CEventVerticalAlignment event = CEventVerticalAlignment.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getVerticalAlignment()});
            this.getComponent().setVerticalAlignment(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyVerticalTextPosition(@NotNull String aKey, @Nullable Object aValue) {
        CEventVerticalTextPosition event = CEventVerticalTextPosition.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getVerticalTextPosition()});
            this.getComponent().setVerticalTextPosition(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyWidthInCharacters(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int col = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set {} to {}", new Object[]{aKey, col});
            FontMetrics metrics = this.mComponent.getFontMetrics(this.mComponent.getFont());
            int columnWidth = metrics.charWidth('m');
            Dimension size = this.mComponent.getPreferredSize();
            if (col != 0) {
                Insets insets = this.mComponent.getInsets();
                size.width = col * columnWidth + insets.left + insets.right;
            }
            this.getComponent().setPreferredSize(size);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Label.name();
    }

    @Override
    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        super.notifyWidget(aNotification, aObjects);
        if (aNotification.equals((Object)ENotification.SHOWN) && this.mLabelFor != null) {
            this.applyLabelFor(this.mLabelFor);
        }
    }

    @Override
    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        super.fileArrived(aRelativePath, aToken, aImage);
        this.mIconHandler.fileArrived(aToken, aImage);
    }
}

