/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.combobox;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.combobox.CComboBoxModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.combobox.CComboCellRenderer;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxEditorNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventUpdateComboBox;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingComboBox
extends CSwingJComponent {
    private final JComboBox<CEventLabelItem> mComponent;
    private final CComboBoxModel mModel = new CComboBoxModel();
    private CEventLabelItem mLastSelectedLabelItem = null;

    public CSwingComboBox(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.mComponent = new JComboBox<CEventLabelItem>(this.mModel);
        this.mComponent.setRenderer(new CComboCellRenderer());
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("editable", this::applyEditable);
        list.addHandler("selectItem", this::applySelection);
        list.addHandler("data", this::applyData);
        list.addHandler("update", this::applyUpdate);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.mComponent.addActionListener(this::onAction);
        this.mComponent.addItemListener(this::onItemChange);
    }

    private boolean applyData(@NotNull String aKey, @Nullable Object aValue) {
        CEventComboBoxContent event = CEventComboBoxContent.create((Object)aValue);
        if (event != null) {
            List items = event.getItems();
            this.mModel.removeAllElements();
            for (CEventLabelItem item : items) {
                this.mModel.addEntry(item);
            }
            Object selectedItem = this.mModel.getSelectedItem();
            if (selectedItem == null && items.size() > 0) {
                this.mLastSelectedLabelItem = (CEventLabelItem)items.get(0);
                this.mModel.setSelectedItem(this.mLastSelectedLabelItem);
            } else {
                this.mLastSelectedLabelItem = (CEventLabelItem)selectedItem;
            }
            return true;
        }
        return false;
    }

    private boolean applyEditable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean editable = (Boolean)aValue;
            ((JComboBox)this.getComponent()).setEditable(editable);
            return true;
        }
        return false;
    }

    private boolean applySelection(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectItem event = CEventSelectItem.create((Object)aValue);
        if (event != null) {
            String id = event.getItemId();
            CEventLabelItem row = this.find(id);
            if (row != null) {
                ((JComboBox)this.getComponent()).setSelectedItem(row);
                this.mLastSelectedLabelItem = row;
            }
            return true;
        }
        return false;
    }

    private boolean applyUpdate(@NotNull String aKey, @Nullable Object aValue) {
        CEventUpdateComboBox event = CEventUpdateComboBox.create((Object)aValue);
        if (event != null) {
            for (CEventLabelItem datum : event.getData()) {
                String id = datum.getId();
                CEventLabelItem entry = this.mModel.getById(id);
                if (entry == null) {
                    this.mModel.addEntry(datum);
                    continue;
                }
                entry.update(datum);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private CEventLabelItem find(@NotNull String aId) {
        ComboBoxModel<CEventLabelItem> model = this.mComponent.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            CEventLabelItem elementAt = (CEventLabelItem)model.getElementAt(i);
            if (!elementAt.getId().equals(aId)) continue;
            return elementAt;
        }
        return null;
    }

    @NotNull
    public JComboBox<CEventLabelItem> getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ComboBox.name();
    }

    private void onAction(ActionEvent aEvent) {
        Component cb = this.getComponent();
        Object selectedItem = ((JComboBox)cb).getSelectedItem();
        if (selectedItem instanceof String) {
            String oldText;
            String newText = (String)selectedItem;
            String lastId = this.mLastSelectedLabelItem == null ? null : this.mLastSelectedLabelItem.getId();
            String string = oldText = this.mLastSelectedLabelItem == null ? "" : this.mLastSelectedLabelItem.getAttributes().getDisplayedText();
            if (!CUtilString.equals((String)newText, (String)oldText)) {
                CEventComboBoxEditorNotification event = new CEventComboBoxEditorNotification(lastId, newText);
                this.addNotification("onComboEdit", event.toJson());
                this.sendNotification();
            }
        }
    }

    private void onItemChange(ItemEvent aEvent) {
        Component cb = this.getComponent();
        Object selectedItem = ((JComboBox)cb).getSelectedItem();
        int selectedIndex = ((JComboBox)cb).getSelectedIndex();
        if (aEvent.getStateChange() == 1 && selectedItem instanceof CEventLabelItem) {
            this.mLastSelectedLabelItem = (CEventLabelItem)selectedItem;
            CEventComboBoxSelectionNotification event = new CEventComboBoxSelectionNotification(this.mLastSelectedLabelItem.getId(), this.mLastSelectedLabelItem.getAttributes().getDisplayedText(), selectedIndex);
            this.addNotification("onComboSelect", event.toJson());
            this.sendNotification();
        }
    }
}

