/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.optionpane;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.optionpane.COptionPane;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringList;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.util.EMessageBoxType;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.awt.event.ActionEvent;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CAbstractSmallDialog
extends CWidget {
    private final COptionPane mComponent;
    private String mTitle = "";
    private JButton[] mButtons = new JButton[0];
    private JDialog mDialog;
    private CWidget mParent = null;

    public CAbstractSmallDialog(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        this.mComponent = new COptionPane();
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("buttons", this::applyButtons);
        list.addHandler("icon", this::applyIcon);
        list.addHandler("indexOfEnterButton", this::applyIndexOfEnterButton);
        list.addHandler("indexOfEscapeButton", this::applyIndexOfEscapeButton);
        list.addHandler("messageType", this::applyMessageType);
        list.addHandler("parent", this::applyParent);
        list.addHandler("text", this::applyText);
        list.addHandler("text64", this::applyText64);
        list.addHandler("title", this::applyTitle);
        list.addHandler("visible", this::applyVisible);
    }

    public void addChildComponent(@NotNull CWidget aWidget) {
    }

    public void addListeners() {
    }

    protected void onAction(@NotNull ActionEvent aEvent) {
        this.addNotification("onMessageBoxResult", aEvent.getActionCommand());
    }

    private boolean applyButtons(@NotNull String aKey, @Nullable Object aValue) {
        COptionPane pane = this.getComponent();
        List list = CUtilJsonStringList.fromJson((Object)aValue);
        if (!list.isEmpty()) {
            this.mButtons = new JButton[list.size()];
            int i = 0;
            for (String text : list) {
                this.mButtons[i] = new JButton(text);
                this.mButtons[i].setActionCommand(text);
                CAbstractSmallDialog mb = this;
                this.mButtons[i].addActionListener(e -> {
                    this.mDialog.dispose();
                    this.onAction(e);
                    this.sendNotification();
                    CWidgetSet ws = this.getWidgetSet();
                    ws.remove((CWidget)mb);
                });
                ++i;
            }
            pane.setOptions(this.mButtons);
            return true;
        }
        return false;
    }

    private boolean applyIcon(@NotNull String aKey, @Nullable Object aValue) {
        CEventIcon event = CEventIcon.fromObject((Object)aValue);
        if (event != null) {
            COptionPane pane = this.getComponent();
            ImageIcon icon = event.createIcon(((Object)((Object)this)).getClass());
            if (icon != null) {
                pane.setIcon(icon);
            } else {
                String path = event.getPath();
                if (path != null) {
                    this.getWidgetSet().getContext().requestFile(path, this.getId(), (Object)"-", EFileDeliveryType.AS_IMAGE);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyIndexOfEnterButton(@NotNull String aKey, @Nullable Object aValue) {
        int index;
        if (aValue instanceof Number && (index = CUtilInteger.fromObject((Object)aValue, (int)-1)) >= 0) {
            COptionPane pane = this.getComponent();
            if (index < this.mButtons.length) {
                JButton button = this.mButtons[index];
                pane.addEnterButton(button);
                return true;
            }
        }
        return false;
    }

    private boolean applyIndexOfEscapeButton(@NotNull String aKey, @Nullable Object aValue) {
        int index;
        if (aValue instanceof Number && (index = CUtilInteger.fromObject((Object)aValue, (int)-1)) >= 0) {
            COptionPane pane = this.getComponent();
            if (index < this.mButtons.length) {
                JButton button = this.mButtons[index];
                pane.addEscapeButton(button);
                return true;
            }
        }
        return false;
    }

    private boolean applyMessageType(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String t = CUtilString.fromObject((Object)aValue, (String)EMessageBoxType.plain.name());
            EMessageBoxType type = EMessageBoxType.valueOf((String)t);
            switch (type) {
                case error: {
                    this.getComponent().setMessageType(0);
                    break;
                }
                case warning: {
                    this.getComponent().setMessageType(2);
                    break;
                }
                case information: {
                    this.getComponent().setMessageType(1);
                    break;
                }
                case question: {
                    this.getComponent().setMessageType(3);
                    break;
                }
                default: {
                    this.getComponent().setMessageType(-1);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyParent(@NotNull String aKey, @Nullable Object aValue) {
        CEventWidgetId event = CEventWidgetId.create((Object)aValue);
        if (event != null) {
            this.mParent = this.getContext().findWidget(event.getWidgetId());
            return true;
        }
        return false;
    }

    private boolean applyTitle(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            this.mTitle = CUtilString.fromObject((Object)aValue, (String)"?");
            return true;
        }
        return false;
    }

    private boolean applyText64(@NotNull String aKey, @Nullable Object aValue) {
        String s;
        if (aValue instanceof String && CUtilString.isValid((String)(s = CUtilString.fromObject((Object)aValue, null)))) {
            byte[] bytes = CUtilBase64.decode((String)s);
            String message = new String(bytes, StandardCharsets.UTF_8);
            this.getComponent().setMessage(message);
            return true;
        }
        return false;
    }

    private boolean applyText(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String s = CUtilString.fromObject((Object)aValue, (String)"?");
            this.getComponent().setMessage(s);
            return true;
        }
        return false;
    }

    private boolean applyVisible(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean show = (Boolean)aValue;
            if (show) {
                COptionPane pane = this.getComponent();
                this.mDialog = this.mParent == null ? pane.createDialog(this.mTitle) : pane.createDialog(this.mParent.getComponent(), this.mTitle);
                this.mDialog.setVisible(true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public COptionPane getComponent() {
        return this.mComponent;
    }

    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        super.fileArrived(aRelativePath, aToken, aImage);
    }
}

