/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeader;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CTableHeaderEntry {
    private final CColumn mColumn;
    private String mText = "";
    private String mToolTip = "";
    private Color mBackground = CNamedColors.get((String)"silver").getColor(100);
    private Color mForeground = UIManager.getColor("tableheader.foreground");
    private ImageIcon mIcon = null;
    private Border mBorder = UIManager.getBorder("tableheader.cellborder");
    private Font mFont;

    CTableHeaderEntry(@NotNull CColumn aColumn) {
        this.mColumn = aColumn;
    }

    @NotNull
    CColumn getColumn() {
        return this.mColumn;
    }

    String getToolTip() {
        return this.mToolTip;
    }

    void setToolTip(String aToolTip) {
        this.mToolTip = aToolTip;
    }

    Color getBackground() {
        return this.mBackground;
    }

    void setBackground(Color aBackground) {
        this.mBackground = aBackground;
    }

    Color getForeground() {
        return this.mForeground;
    }

    void setForeground(Color aForeground) {
        this.mForeground = aForeground;
    }

    ImageIcon getIcon() {
        return this.mIcon;
    }

    void setIcon(ImageIcon aIcon) {
        this.mIcon = aIcon;
    }

    Border getBorder() {
        return this.mBorder;
    }

    void setBorder(Border aBorder) {
        this.mBorder = aBorder;
    }

    Font getFont() {
        return this.mFont;
    }

    void setFont(Font aFont) {
        this.mFont = aFont;
    }

    String getText() {
        return this.mText;
    }

    void setText(@NotNull String aText) {
        this.mText = aText;
    }

    void apply(CEventTableHeader aEvent) {
        Object o;
        Font font;
        CEventFont eventFont;
        Border border;
        IBorder headerBorder;
        CEventIcon evIcon;
        CEventColor headerForeground;
        CEventColor headerBackground;
        CEventLabelAttributes la = aEvent.getLabelAttributes();
        String s = la.getTooltip();
        if (s != null) {
            this.setToolTip(s);
        }
        if ((headerBackground = la.getBackground()) != null) {
            this.setBackground(headerBackground.createColor());
        }
        if ((headerForeground = la.getForeground()) != null) {
            this.setForeground(headerForeground.createColor());
        }
        if ((evIcon = la.getIcon()) != null) {
            ImageIcon icon = evIcon.createIcon(this.getClass());
            if (icon != null) {
                this.setIcon(icon);
            } else {
                String path = evIcon.getPath();
                if (path != null) {
                    CWidget widget = this.mColumn.getTable().getWidget();
                    widget.getWidgetSet().getContext().requestFile(path, widget.getId(), (Object)new Point(evIcon.getX(), -1), EFileDeliveryType.AS_IMAGE);
                }
            }
        }
        if ((headerBorder = la.getBorder()) != null && (border = headerBorder.createBorder()) != null) {
            this.setBorder(border);
        }
        if ((eventFont = la.getFont()) != null && (font = eventFont.createFont()) != null) {
            this.setFont(font);
        }
        if ((o = la.getValue()) != null) {
            this.setText(o.toString());
        }
    }
}

