/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver.ssl;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

class StaticFileHandler
implements HttpHandler {
    private final Path mWebRootPath;

    StaticFileHandler(@NotNull Path aWebRootPath) {
        this.mWebRootPath = aWebRootPath;
    }

    @Override
    public void handle(@NotNull HttpExchange aExchange) throws IOException {
        Path filePath;
        String uri = aExchange.getRequestURI().getPath();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (Files.exists(filePath = this.mWebRootPath.resolve(uri), new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0])) {
            byte[] fileBytes = Files.readAllBytes(filePath);
            aExchange.sendResponseHeaders(200, fileBytes.length);
            OutputStream os = aExchange.getResponseBody();
            os.write(fileBytes);
            os.close();
        } else {
            String response = "404 (Not Found)\n";
            aExchange.sendResponseHeaders(404, "404 (Not Found)\n".length());
            OutputStream os = aExchange.getResponseBody();
            os.write("404 (Not Found)\n".getBytes());
            os.close();
        }
    }
}

