/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordRemoteSkinStoreWidgetSets
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"de3fa118-540e-40d7-a7e9-48aa25773129");
    public static final String NAME = "RemoteSkinStoreWidgetSets";
    public static final String DESCRIPTION = "Store a widget set at client side. Receiver: RemoteSkinClientContext";
    public static final String SLOT_WIDGET_SET = "ws";
    public static final String SLOT_WIDGET_SETS = "wsArr";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getWidgetSet(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_WIDGET_SET);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String[] getWidgetSets(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_WIDGET_SETS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setWidgetSet(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_WIDGET_SET, slot);
    }

    public static void setWidgetSets(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_WIDGET_SETS, slot);
    }
}

