/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.app.chooseapp;

import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordGetApplicationListForUser;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.web.app.chooseapp.CAppEntry;
import de.sillysky.nyssr.impl.web.app.chooseapp.ILocalAppContext;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class C00200ChooseApp
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(C00200ChooseApp.class);
    private static final String PREFIX_ID = "id_";
    private final ILocalAppContext mLocalAppContext;
    private final String mMainWidgetId;
    private final List<CAppEntry> mAppEntries = new ArrayList<CAppEntry>();
    private CWebApi mWebApi;

    C00200ChooseApp(@NotNull ILocalAppContext aLocalAppContext, @NotNull String aMainWidgetId) {
        this.mLocalAppContext = aLocalAppContext;
        this.mMainWidgetId = aMainWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordGetApplicationListForUser.ID, this::asyncGetApplicationListForUser);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncLfsGetFile);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebOnClick2);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mLocalAppContext.getApplicationContext().getClientRemoteSkinAddress());
        String html = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00200_main.html");
        this.mWebApi.setInnerHtml(this.mMainWidgetId, html);
        this.sendGetApps();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetApplicationListForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] records;
            LOG.debug("Get Apps: " + aEnvelope.getResult());
            if (aEnvelope.getResultCode() == 0 && (records = CRecordGetApplicationListForUser.getApplicationList((CRecord)aRecord, null)) != null) {
                this.mAppEntries.clear();
                for (CRecord rec : records) {
                    UUID id = CRecordApplication.getId((CRecord)rec, null);
                    String iconPath = CRecordApplication.getIcon((CRecord)rec, (String)"");
                    String applicationName = CRecordApplication.getName((CRecord)rec, (String)"");
                    String shortDescription = CRecordApplication.getShortDescription((CRecord)rec, (String)"");
                    String longDescription = CRecordApplication.getLongDescription((CRecord)rec, (String)"");
                    CAppEntry entry = new CAppEntry(id, applicationName, shortDescription, longDescription, iconPath);
                    LOG.debug("App: " + entry);
                    this.mAppEntries.add(entry);
                    if (!CUtilString.isValid((String)iconPath)) continue;
                    this.sendRequestIcon(entry);
                }
                this.createTable();
            }
            return true;
        }
        return false;
    }

    private boolean asyncLfsGetFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            UUID transactionId;
            CResult result = aEnvelope.getResult();
            if (result.isSuccess() && (transactionId = aEnvelope.getTransactionId()) != null) {
                for (CAppEntry appEntry : this.mAppEntries) {
                    if (!transactionId.equals(appEntry.getTransactionId())) continue;
                    byte[] bytes = CRecordFileStoreRequestFile.getBytes((CRecord)aRecord, null);
                    String path = CRecordFileStoreRequestFile.getPath((CRecord)aRecord, null);
                    if (bytes == null) continue;
                    SwingUtilities.invokeLater(() -> {
                        ImageIcon image = new ImageIcon(bytes, path);
                        appEntry.setIcon(image);
                    });
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebOnClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on onClick", (Object[])new Object[0]);
        id = id.substring(PREFIX_ID.length());
        byte[] sessionToken = this.mLocalAppContext.getSessionToken();
        CStringProperties sp = new CStringProperties();
        sp.put("applicationId", id);
        this.mWebApi.openNewTab(true, null, sp, sessionToken);
        aEnvelope.setResultSuccess();
        return true;
    }

    private void sendGetApps() throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        env.setSessionToken(this.mLocalAppContext.getSessionToken());
        CRecord record = CRecordGetApplicationListForUser.create();
        CRecordGetApplicationListForUser.setPlatform((CRecord)record, (String)"web");
        this.sendRequest(env, record);
    }

    private void sendRequestIcon(@NotNull CAppEntry aEntry) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        env.setTransactionId(aEntry.getTransactionId());
        CRecord record = CRecordFileStoreRequestFile.create();
        CRecordFileStoreRequestFile.setPath((CRecord)record, (String)aEntry.getIconPath());
        CRecordFileStoreRequestFile.setDeliveryType((CRecord)record, (byte)EFileDeliveryType.BYTES.getType());
        this.sendRequest(env, record);
    }

    private void createTable() throws CException {
        ArrayList<String> ids = new ArrayList<String>();
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00200_main.html");
        String table = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00200_table.html");
        String row = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00200_row.html");
        String currentTable = table;
        for (CAppEntry appEntry : this.mAppEntries) {
            String currentRow = row;
            currentRow = CUtilString.replaceFirstOccurrence((String)currentRow, (String)"{name}", (String)appEntry.getApplicationName());
            currentRow = CUtilString.replaceFirstOccurrence((String)currentRow, (String)"{description}", (String)appEntry.getLongDescription());
            String id = appEntry.getId().toString();
            ids.add(PREFIX_ID + id);
            currentRow = CUtilString.replaceFirstOccurrence((String)currentRow, (String)"{id}", (String)(PREFIX_ID + id));
            currentTable = CUtilString.insertBeforeFirstOccurrence((String)currentTable, (String)"{row}", (String)currentRow);
        }
        currentTable = CUtilString.replaceFirstOccurrence((String)currentTable, (String)"{row}", (String)"");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{table}", (String)currentTable);
        this.mWebApi.setInnerHtml(this.mMainWidgetId, main);
        this.mWebApi.addClickListener2(ids.toArray(new String[0]));
    }

    void deactivate() throws CException {
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

