/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.util.CUtilByte;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class CByteArrayToString
implements IConverter<Byte[], String> {
    private IConverterRegistry mRegistry;

    @Override
    public String convertTo(Byte[] aObj, Map<String, Object> aConstraints) {
        Object typeObject;
        if (aObj == null) {
            return null;
        }
        if (aConstraints != null && (typeObject = aConstraints.get("type")) != null && typeObject instanceof Integer) {
            switch ((Integer)typeObject) {
                case 1: {
                    return this.convertToByteList(aObj, aConstraints);
                }
                case 2: {
                    return this.convertToSteadyByteString(aObj, aConstraints);
                }
            }
        }
        return this.convertToByteList(aObj, aConstraints);
    }

    private String convertToByteList(Byte[] aObj, Map<String, Object> aConstraints) {
        ArrayList<String> list = new ArrayList<String>();
        IConverter<Byte, String> c1 = this.mRegistry.get(Byte.class, "", String.class, "");
        for (Byte b : aObj) {
            list.add(c1.convertTo(b, aConstraints));
        }
        return this.mRegistry.convert(Collection.class, "", String.class, "", list, null);
    }

    private String convertToSteadyByteString(Byte[] aObj, Map<String, Object> aConstraints) {
        if (aObj == null || aObj.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(aObj.length * 2 + 1);
        Byte[] byteArray = aObj;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte b = byteArray[i];
            CUtilByte.append(sb, b);
        }
        return sb.toString();
    }

    @Override
    public Class<?> getDestinationClass() {
        return String.class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return Byte[].class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
        this.mRegistry = aRegistry;
    }
}

