/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.preferences.manager;

import de.sillysky.nyssr.configuration.files.records.CRecordAddPreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreference;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordGetPreference;
import de.sillysky.nyssr.configuration.files.records.CRecordGetPreferenceList;
import de.sillysky.nyssr.configuration.files.records.CRecordSetPreference;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.kernel.config.preferences.manager.CUtilPreference;
import de.sillysky.nyssr.impl.kernel.config.preferences.manager.IDependencies;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWorkingTarget
extends CTarget {
    private static final IId MICRO_SERVICE_ID_SESSION = CIdFactory.fromObject("ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private final IDependencies mDependencies;
    private final byte[] mSessionToken;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;

    CWorkingTarget(@NotNull IDependencies aDependencies, byte[] aSessionToken, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mSessionToken = aSessionToken;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendSessionValidate();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, BackingStoreException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                IId id;
                String[] rights = CRecordSessionValidate.getRights(aRecord, null);
                if (!this.checkRights(rights)) {
                    this.sendFinished(5105, "Missing Right");
                }
                if (CRecordGetPreference.ID.equals(id = this.mRecord.getId())) {
                    this.getPreference();
                } else if (CRecordGetPreferenceList.ID.equals(id)) {
                    this.getPreferenceList();
                } else if (CRecordSetPreference.ID.equals(id)) {
                    this.setPreference();
                } else if (CRecordDeletePreference.ID.equals(id)) {
                    this.deletePreference();
                } else if (CRecordAddPreferenceNode.ID.equals(id)) {
                    this.addPreferenceNode();
                } else if (CRecordDeletePreferenceNode.ID.equals(id)) {
                    this.deletePreferenceNode();
                } else {
                    this.sendFinished(15, "unknown message");
                }
            } else {
                this.sendFinished(resultCode, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private void getPreferenceList() throws CException, BackingStoreException {
        HashMap<String, String> preferencesMap = new HashMap<String, String>();
        Preferences rootNode = this.mDependencies.getKernelConfiguration().getPreferences("");
        @NotNull String[] nodes = CUtilPreference.listAllPreferenceNodePaths(rootNode);
        CRecordGetPreferenceList.setNodes(this.mRecord, nodes);
        CUtilPreference.fillPreferencesMap(rootNode, "", preferencesMap);
        CStringProperties sp = new CStringProperties(preferencesMap);
        CRecordGetPreferenceList.setKeyValuePairs(this.mRecord, sp);
        this.sendFinished(0, "");
    }

    private void getPreference() throws CException {
        String inKey = CRecordGetPreference.getKey(this.mRecord, "");
        Object[] oo = this.locate(inKey);
        if (oo != null) {
            Preferences preferences = (Preferences)oo[0];
            String key = (String)oo[1];
            String value = preferences.get(key, "");
            CRecordGetPreference.setValue(this.mRecord, value);
            this.sendFinished(0, "");
        }
    }

    private void setPreference() throws CException {
        String inKey = CRecordSetPreference.getKey(this.mRecord, "");
        Object[] oo = this.locate(inKey);
        if (oo != null) {
            Preferences preferences = (Preferences)oo[0];
            String key = (String)oo[1];
            String value = CRecordSetPreference.getValue(this.mRecord, "");
            preferences.put(key, value);
            this.sendFinished(0, "");
        }
    }

    private void addPreferenceNode() throws CException {
        String inKey = CRecordAddPreferenceNode.getNodeName(this.mRecord, "");
        Object[] oo = this.locate(inKey);
        if (oo != null) {
            Preferences preferences = (Preferences)oo[0];
            String nodeName = (String)oo[1];
            preferences.node(nodeName);
            this.sendFinished(0, "");
        }
    }

    private void deletePreference() throws CException {
        String inKey = CRecordDeletePreference.getKey(this.mRecord, "");
        Object[] oo = this.locate(inKey);
        if (oo != null) {
            Preferences preferences = (Preferences)oo[0];
            String key = (String)oo[1];
            preferences.remove(key);
            this.sendFinished(0, "");
        }
    }

    private void deletePreferenceNode() throws CException, BackingStoreException {
        String path = CRecordDeletePreferenceNode.getNodePath(this.mRecord, "");
        Object[] oo = this.locate(path);
        if (oo != null) {
            Preferences preferences = (Preferences)oo[0];
            preferences.node((String)oo[1]).removeNode();
            this.sendFinished(0, "");
        }
    }

    private Object @Nullable [] locate(@NotNull String aKey) throws CException {
        Preferences preferences;
        if (CUtilString.isEmpty(aKey)) {
            this.sendFinished(8, "Key missing");
            return null;
        }
        String key = CUtilString.removeFirstChar(aKey, '/');
        int pos = key.lastIndexOf(47);
        if (pos < 0) {
            preferences = this.mDependencies.getKernelConfiguration().getPreferences("");
            key = aKey;
        } else {
            String nodePath = key.substring(0, pos);
            key = key.substring(pos + 1);
            preferences = this.mDependencies.getKernelConfiguration().getPreferences(nodePath);
        }
        return new Object[]{preferences, key};
    }

    private boolean checkRights(String[] aRights) {
        if (aRights != null) {
            for (String right : aRights) {
                if (!right.equalsIgnoreCase("NY_EditConfiguration")) continue;
                return true;
            }
        }
        return false;
    }

    private void sendSessionValidate() throws CException {
        CEnvelope env = CEnvelope.forMicroService(MICRO_SERVICE_ID_SESSION);
        env.setSessionToken(this.mSessionToken);
        CRecord record = CRecordSessionValidate.create();
        this.sendRequest(env, record);
    }

    private void sendFinished(int aResultCode, @NotNull String aResultText) throws CException {
        this.mEnvelope.setResult(aResultCode, aResultText);
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
    }
}

