/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.hook;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.hook.CMessageHookRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.hook.EMessageHookCause;
import de.sillysky.nyssr.message.hook.IMessageHook;
import de.sillysky.nyssr.message.hook.records.CRecordNotifyMessageHooked;
import de.sillysky.nyssr.record.CRecord;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class CAsyncMessageHook
implements IMessageHook {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAsyncMessageHook.class);
    private static final IId[] THESE_NOT = new IId[]{CRecordNotifyMessageHooked.ID};
    private final List<CTargetAddress> mFilterList;
    private final CTargetAddress mObserver;
    private final CMessageHookRegistry mRegistry;

    CAsyncMessageHook(CMessageHookRegistry aRegistry, CTargetAddress aObserver, CTargetAddress[] aFilterList) {
        this.mRegistry = aRegistry;
        this.mObserver = aObserver;
        this.mFilterList = new CopyOnWriteArrayList<CTargetAddress>();
        this.setFilterList(aFilterList);
    }

    private boolean canBeHooked(IId aId) {
        for (IId id : THESE_NOT) {
            if (!id.equals(aId)) continue;
            return false;
        }
        return true;
    }

    private boolean canHook(CMessage aMsg) {
        CEnvelope env;
        boolean result = false;
        if (aMsg != null && !(env = aMsg.getEnvelope()).isOnlyLocal() && env.isLogEnabled()) {
            result = true;
            CRecord rec = aMsg.getRecord();
            IId id = rec.getId();
            if (!this.canBeHooked(id)) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public Iterator<CTargetAddress> getFilter() {
        return this.mFilterList.iterator();
    }

    @Override
    public CMessage hook(CMessage aMsg, EMessageHookCause aCause) {
        if (this.canHook(aMsg)) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget(this.mObserver);
                CRecord rec = CRecordNotifyMessageHooked.create();
                CMessage msgCopy = this.prepareCopy(aMsg);
                CRecordNotifyMessageHooked.setMessage(rec, msgCopy);
                CRecordNotifyMessageHooked.setCause(rec, aCause.toString());
                this.mRegistry.sendNotification(env, rec);
            }
            catch (CException e) {
                LOG.error("Exception on send hooked message: {}", e.getMessage());
            }
        }
        return aMsg;
    }

    private CMessage prepareCopy(CMessage aMsg) {
        return new CMessage(aMsg);
    }

    void setFilterList(CTargetAddress[] aFilterList) {
        this.mFilterList.clear();
        if (aFilterList != null) {
            Collections.addAll(this.mFilterList, aFilterList);
        }
    }
}

