/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice.monitor.target.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordTargetMonitorAddFilter
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("4a9d268d-0e28-4bad-ab2b-7c01fe5acf42");
    public static final String NAME = "TargetMonitorAddFilter";
    public static final String DESCRIPTION = "Add one or more Target Monitor Filter.";
    public static final String SLOT_FILTER = "ob";
    public static final String SLOT_FILTERS = "obx";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_OBSERVER = "obs";
    public static final String SLOT_REMOVE_OLD = "remove";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getFilter(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static CTargetAddress[] getFilters(@NotNull CRecord aRecord, CTargetAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTERS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress[])slot.getValue();
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress getObserver(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static boolean getRemoveOld(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOVE_OLD);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setFilter(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_FILTER, slot);
    }

    public static void setFilters(@NotNull CRecord aRecord, CTargetAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS_ARRAY, aValue);
        aRecord.addSlot(SLOT_FILTERS, slot);
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setObserver(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_OBSERVER, slot);
    }

    public static void setRemoveOld(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_REMOVE_OLD, slot);
    }
}

