/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.time.CUtilLocalDate;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSlotLocalDate
implements ISlot,
ISingleSlotTypeFactory {
    private final LocalDate mValue;

    public CSlotLocalDate() {
        this.mValue = null;
    }

    public CSlotLocalDate(LocalDate aValue) {
        this.mValue = aValue;
    }

    public CSlotLocalDate(@NotNull List<?> aValue) {
        Object object = aValue.get(0);
        this.mValue = this.create(object);
    }

    public CSlotLocalDate(String aValue) {
        this.mValue = this.create(aValue);
    }

    public CSlotLocalDate(@NotNull DataInput aStream) throws IOException {
        String s = aStream.readUTF();
        this.mValue = LocalDate.parse(s);
    }

    private LocalDate create(Object aValue) {
        LocalDate result = null;
        if (aValue != null) {
            if (aValue instanceof LocalDate) {
                result = (LocalDate)aValue;
            } else if (aValue instanceof LocalDateTime) {
                LocalDateTime dt = (LocalDateTime)aValue;
                result = dt.toLocalDate();
            } else if (aValue instanceof String) {
                result = LocalDate.parse((String)aValue);
            }
        }
        return result;
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return new CSlotLocalDate(this.create(aValue));
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            LocalDate localDate = CUtilLocalDate.fromIsoString((String)aValue);
            return new CSlotLocalDate(localDate);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotLocalDate other = (CSlotLocalDate)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    public LocalDate get() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return LocalDateTime.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    public String getString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.valueToString();
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.LOCAL_DATE;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        return this.equals(aValue);
    }

    @Override
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return new CSlotLocalDate(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        String s = this.valueToString();
        aStream.writeUTF(s);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue == null) {
            return "";
        }
        return this.mValue.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return CUtilLocalDate.valueToIsoString(this.mValue);
        }
        return null;
    }
}

