/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNanoServiceUpdateServices
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("fd6a49ce-52a4-4862-af96-7e729ead7a5a");
    public static final String NAME = "NanoServiceUpdateServices";
    public static final String DESCRIPTION = "Send service information to a receiver.";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_SERVICES = "serv";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CRecord[] getServices(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SERVICES);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setServices(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.RECORD_ARRAY, aValue);
        aRecord.addSlot(SLOT_SERVICES, slot);
    }
}

