/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target.registry.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetTargetInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("f7bdd19a-fd38-4eac-a3a2-c5957196e6d9");
    public static final String NAME = "GetTargetInfo";
    public static final String DESCRIPTION = "Get information about one or more targets.";
    public static final String SLOT_ALL_TARGETS = "all";
    public static final String SLOT_NAMESPACE_ID = "nid";
    public static final String SLOT_TARGETS = "records";
    public static final String SLOT_TID = "tid";
    public static final String SLOT_TIDS = "tids";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getAllTargets(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ALL_TARGETS);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static IId getNamespaceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAMESPACE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CRecord[] getTargets(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGETS);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static IId getTid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId[] getTids(@NotNull CRecord aRecord, IId[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIDS);
        if (slot == null) {
            return aDefault;
        }
        return (IId[])slot.getValue();
    }

    public static void setAllTargets(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_ALL_TARGETS, slot);
    }

    public static void setNamespaceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NAMESPACE_ID, slot);
    }

    public static void setTargets(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.RECORD_ARRAY, aValue);
        aRecord.addSlot(SLOT_TARGETS, slot);
    }

    public static void setTid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_TID, slot);
    }

    public static void setTids(@NotNull CRecord aRecord, IId[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID_ARRAY, aValue);
        aRecord.addSlot(SLOT_TIDS, slot);
    }
}

