/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilLongArray {
    public static final long[] EMPTY = new long[0];

    private CUtilLongArray() {
    }

    public static long @Nullable [] copy(long @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static long @NotNull [] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (Object element : aValue) {
            long[] lArray;
            if (element == null) continue;
            if (element instanceof Long) {
                Long e = (Long)element;
                list.add(e);
                continue;
            }
            if (element instanceof Long[]) {
                Long[] ee2 = (Long[])element;
                Collections.addAll(list, ee2);
                continue;
            }
            if (element instanceof long[]) {
                long[] ee;
                for (long e : ee = (long[])element) {
                    list.add(e);
                }
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            for (long e : lArray = CUtilLongArray.fromString(s)) {
                list.add(e);
            }
        }
        long[] arr = new long[list.size()];
        int pos = 0;
        for (Long l : list) {
            arr[pos] = l;
            ++pos;
        }
        return arr;
    }

    public static long @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        long[] value = new long[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = aStream.readLong();
        }
        return value;
    }

    public static long @NotNull [] random(int aLength) {
        long[] array = new long[aLength];
        for (int i = 0; i < aLength; ++i) {
            array[i] = CUtilRandom.getRandom().nextLong();
        }
        return array;
    }

    public static long @NotNull [] fromString(@Nullable String aValue) {
        return CUtilLongArray.fromString(aValue, ",");
    }

    public static long @NotNull [] fromString(@Nullable String aValue, @NotNull String aDelimiter) {
        long[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = new long[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new long[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilLong.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(long @Nullable [] aValue1, long @Nullable [] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    public static boolean isEqual(@Nullable @Nullable Long @Nullable [] aValue1, long @Nullable [] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        if (aValue1.length != aValue2.length) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (aValue1[i] != null && aValue1[i] == aValue2[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String toString(long @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : Long.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, long @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (long element : aValue) {
                aStream.writeLong(element);
            }
        }
    }
}

