/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.password.change;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.password.change.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPasswordNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPasswordListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C800Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWsId;
    private final CWidgetId mDialog;
    private final CWidgetId mButtonOkay;
    private final CWidgetId mLabelMessage;
    private final boolean mWithUserField;
    private String mEncodedCurrentPassword;
    private String mEncodedNewPassword1;
    private String mEncodedNewPassword2;
    private boolean mButtonOkayIsEnabled = false;
    private boolean mIsDialogOpen = false;
    private String mUserId;

    C800Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance, @Nullable String aUserId) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWithUserField = CUtilString.isEmpty((String)aUserId);
        if (this.mWithUserField) {
            this.mWsId = CWidgetSetId.create((String)"@801_PasswordChangeWithUserId", (String)aInstance);
            this.mDialog = CWidgetId.create((String)"#801_Dialog", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(this.mDialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
            CWidgetId tfUserId = CWidgetId.create((String)"#801_UserId", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(tfUserId, (IListener)((ITextChangeListener)this::onUserId));
            CWidgetId pfOldPw = CWidgetId.create((String)"#801_CurrentPassword", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfOldPw, (IListener)((IPasswordListener)this::onCurrentPassword));
            CWidgetId pfNewPw1 = CWidgetId.create((String)"#801_NewPassword1", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfNewPw1, (IListener)((IPasswordListener)this::onNewPassword1));
            CWidgetId pfNewPw2 = CWidgetId.create((String)"#801_NewPassword2", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfNewPw2, (IListener)((IPasswordListener)this::onNewPassword2));
            this.mButtonOkay = CWidgetId.create((String)"#801_ButtonOkay", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(this.mButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
            CWidgetId buttonCancel = CWidgetId.create((String)"#801_ButtonCancel", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(buttonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
            this.mLabelMessage = CWidgetId.create((String)"#801_LabelMessage", (CWidgetSetId)this.mWsId);
        } else {
            this.mUserId = aUserId;
            this.mWsId = CWidgetSetId.create((String)"@800_PasswordChange", (String)aInstance);
            this.mDialog = CWidgetId.create((String)"#800_Dialog", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(this.mDialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
            CWidgetId pfOldPw = CWidgetId.create((String)"#800_CurrentPassword", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfOldPw, (IListener)((IPasswordListener)this::onCurrentPassword));
            CWidgetId pfNewPw1 = CWidgetId.create((String)"#800_NewPassword1", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfNewPw1, (IListener)((IPasswordListener)this::onNewPassword1));
            CWidgetId pfNewPw2 = CWidgetId.create((String)"#800_NewPassword2", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(pfNewPw2, (IListener)((IPasswordListener)this::onNewPassword2));
            this.mButtonOkay = CWidgetId.create((String)"#800_ButtonOkay", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(this.mButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
            CWidgetId buttonCancel = CWidgetId.create((String)"#800_ButtonCancel", (CWidgetSetId)this.mWsId);
            this.mApi.addListener(buttonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
            this.mLabelMessage = CWidgetId.create((String)"#800_LabelMessage", (CWidgetSetId)this.mWsId);
        }
    }

    private void onUserId(@NotNull CEventTextChangeNotification aEvent) {
        this.mUserId = aEvent.getText();
        this.check();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.sendChangePassword(this.mUserId, this.mEncodedCurrentPassword, this.mEncodedNewPassword1);
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    private void onCurrentPassword(@NotNull CEventPasswordNotification aEvent) {
        this.mEncodedCurrentPassword = aEvent.getEncodedPasswordBase64();
        this.check();
    }

    private void onNewPassword1(@NotNull CEventPasswordNotification aEvent) {
        this.mEncodedNewPassword1 = aEvent.getEncodedPasswordBase64();
        this.check();
    }

    private void onNewPassword2(@NotNull CEventPasswordNotification aEvent) {
        this.mEncodedNewPassword2 = aEvent.getEncodedPasswordBase64();
        this.check();
    }

    private void check() {
        boolean okayEnabled = true;
        if (CUtilString.equals((String)this.mEncodedNewPassword1, (String)this.mEncodedNewPassword2)) {
            this.mApi.setText(this.mLabelMessage, "New Passwords are equal");
        } else {
            okayEnabled = false;
            this.mApi.setText(this.mLabelMessage, "New Passwords are different");
        }
        this.enableButtonOkay(okayEnabled);
        this.sendUpdate();
    }

    private void enableButtonOkay(boolean aEnabled) {
        if (this.mButtonOkayIsEnabled != aEnabled) {
            this.mButtonOkayIsEnabled = aEnabled;
            this.mApi.setEnabled(this.mButtonOkay, this.mButtonOkayIsEnabled);
        }
    }

    void mount(@NotNull CWidgetId aParentWidgetId) {
        if (!this.mIsDialogOpen) {
            this.mServerContext.mountWidgetSet(this.mWsId, aParentWidgetId, this.mWithUserField ? "#801_PanelBackground" : "#800_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWsId.equals((Object)aWidgetSetId)) {
            this.mIsDialogOpen = true;
            this.mMainTarget.notifyWs800Loaded();
            this.mApi.pack(this.mDialog);
            this.mApi.centerWidget(this.mDialog, this.mMainTarget.getDialogDto().getParentWidgetId());
            if (this.mUserId != null) {
                this.mApi.setTitle(this.mDialog, "Change Password for user " + this.mUserId);
            }
            this.mApi.setVisible(this.mDialog, true);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    void unmount() {
        if (this.mIsDialogOpen) {
            this.mIsDialogOpen = false;
            this.mApi.unmount(this.mDialog);
            this.sendUpdate();
        }
    }

    void setMessage(@NotNull String aMessage) {
        this.mApi.setText(this.mLabelMessage, aMessage);
        this.sendUpdate();
    }
}

