/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.edituser;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.edituser.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateUserRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilEmail;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00301EditUser
extends CTarget {
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mUserId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00301_MODAL = "id_00301_modal";
    private static final String ID_00301_CANCEL = "id_00301_cancel";
    private static final String ID_00301_SAVE = "id_00301_save";
    private static final String ID_00301_BY = "id_00301_by";
    private static final String ID_00301_EMAIL = "id_00301_email";
    private static final String ID_00301_PICTURE = "id_00301_picture";
    private static final String ID_00301_REALNAME = "id_00301_realname";
    private static final String ID_00301_USERID = "id_00301_userid";
    private static final String[] WIDGETS = new String[]{"id_00301_cancel", "id_00301_save"};
    private CTargetAddress mUserDbAddress;
    private CUser mUser;

    public C00301EditUser(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aUserId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mUserId = aUserId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetUserRecord.ID, this::asyncGetUserRecord);
        this.addMessageHandler(CRecordUserDbUpdateUserRecord.ID, this::asyncUserDbUpdateUserRecord);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetUserData(this.mUserId);
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String userId = values.get(ID_00301_USERID, "");
            String realName = values.get(ID_00301_REALNAME, "");
            String email = values.get(ID_00301_EMAIL, "");
            String picture = values.get(ID_00301_PICTURE, "");
            if (!CUtilEmail.isValidEmail((String)email)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00301_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"This is not a valid email address.");
                this.mWebApi.setInnerHtml("id_00301_email_alert", alert);
            } else {
                this.sendSetUserData(userId, realName, email, picture);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                CRecord userRecord = CRecordUserDbGetUserRecord.getUser((CRecord)aRecord, null);
                this.mUser = CUser.fromRecord((CRecord)userRecord);
                this.showDialog();
            }
            return true;
        }
        return false;
    }

    private boolean asyncUserDbUpdateUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String email;
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00301_edit_user.html");
        this.mWebApi.removeElement(ID_00301_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.setValue(ID_00301_USERID, this.mUserId);
        String realName = this.mUser.getRealName();
        if (CUtilString.isValid((String)realName)) {
            this.mWebApi.setValue(ID_00301_REALNAME, realName);
        }
        if (CUtilString.isValid((String)(email = this.mUser.getEmail()))) {
            this.mWebApi.setValue(ID_00301_EMAIL, email);
        }
        String picture = this.mUser.getPicture();
        this.mWebApi.setValue(ID_00301_PICTURE, picture);
        this.mWebApi.setValue(ID_00301_BY, this.mUser.getTimeCreated() + " by " + this.mUser.getCreatedByUser());
        this.mWebApi.showModal(ID_00301_MODAL);
        this.mWebApi.addClickListener1(ID_00301_SAVE, new String[]{ID_00301_USERID, ID_00301_EMAIL, ID_00301_PICTURE, ID_00301_REALNAME});
        this.mWebApi.addClickListener2(new String[]{ID_00301_CANCEL});
    }

    private void sendGetUserData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetUserRecord.create();
        CRecordUserDbGetUserRecord.setUserId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void sendSetUserData(@NotNull String aUserId, @NotNull String aRealName, @NotNull String aEmail, @NotNull String aPicture) throws CException {
        CRecord record = CRecordUserDbUpdateUserRecord.create();
        CRecordUserDbUpdateUserRecord.setUserId((CRecord)record, (String)aUserId);
        CRecordUserDbUpdateUserRecord.setRealName((CRecord)record, (String)aRealName);
        CRecordUserDbUpdateUserRecord.setEmail((CRecord)record, (String)aEmail);
        CRecordUserDbUpdateUserRecord.setPicture((CRecord)record, (String)aPicture);
        this.sendMessageToSessionManager(record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00301_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

