/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver.ssl;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import de.sillysky.nyssr.impl.webserver.ssl.CStaticFileHandler;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWebServerSsl {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWebServerSsl.class);
    private final int mPort;
    private final Path mWebRootPath;
    private final Path mKeyStorePath;
    private final char[] mPassphrase;

    CWebServerSsl(int aPort, @NotNull Path aWebRootPath, @Nullable Path aKeyStorePath, char[] aPassphrase) {
        this.mPort = aPort;
        this.mWebRootPath = aWebRootPath;
        this.mKeyStorePath = aKeyStorePath;
        this.mPassphrase = aPassphrase;
    }

    void start() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        if (this.mKeyStorePath != null) {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(Files.newInputStream(this.mKeyStorePath, new OpenOption[0]), this.mPassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.mPassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            HttpsServer server = HttpsServer.create(new InetSocketAddress(this.mPort), 0);
            server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    SSLContext context = this.getSSLContext();
                    SSLEngine engine = context.createSSLEngine();
                    SSLParameters sslParameters = context.getSupportedSSLParameters();
                    sslParameters.setNeedClientAuth(false);
                    sslParameters.setCipherSuites(engine.getEnabledCipherSuites());
                    sslParameters.setUseCipherSuitesOrder(true);
                    sslParameters.setProtocols(new String[]{"TLSv1.3", "TLSv1.2"});
                    params.setSSLParameters(sslParameters);
                }
            });
            server.createContext("/", new CStaticFileHandler(this.mWebRootPath));
            server.setExecutor(null);
            server.start();
            LOG.info("SSL-Server started on port {}", new Object[]{this.mPort});
        }
    }

    public void stop() {
    }
}

