/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui.connect;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.client.node.ui.CUtilUi;
import de.sillysky.nyssr.impl.client.node.ui.EStatus;
import de.sillysky.nyssr.impl.client.node.ui.IClientNodeDependencies;
import de.sillysky.nyssr.impl.client.node.ui.INodeClient;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import de.sillysky.nyssr.util.swing.border.CBubbleBorder;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CConnectDialog
extends JDialog {
    private static final ILogger LOG = CLoggerFactory.getLogger(CConnectDialog.class);
    private static final long serialVersionUID = -5142628295644615689L;
    private static final int RETRY_TIMEOUT = 5000;
    private static final Font FONT_LABEL = new Font("Helvetica", 0, 14);
    private static final Font FONT_EDIT = new Font("Helvetica", 1, 16);
    private final CBubbleBorder mBubbleBorder = new CBubbleBorder();
    private final INodeClient mNodeClient;
    private final IClientNodeDependencies mDependencies;
    private final JComboBox<String> mComboAddress;
    private final JTextField mTextFieldUserId;
    private final JPasswordField mPasswordField;
    private final JLabel mLabelHint;
    private final JProgressBar mProgress;
    private JButton mButtonOkay;
    private JButton mButtonCancel;

    public CConnectDialog(@NotNull INodeClient aNodeClient, @NotNull IClientNodeDependencies aDependencies) {
        super(null, Dialog.ModalityType.TOOLKIT_MODAL);
        this.mNodeClient = aNodeClient;
        this.mDependencies = aDependencies;
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect to Node Backbone");
        this.setUndecorated(false);
        CUtilUi.setImage(this);
        this.mBubbleBorder.setLineColor(Color.WHITE);
        this.mBubbleBorder.setRadius(8);
        this.mBubbleBorder.setThickness(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("fill, gap 0, wrap 1", "[fill]", "[grow 0][fill]10[grow 0][fill]10[grow 0][fill]20[grow 0]"));
        contentPane.setBackground(CNamedColors.get((String)"LightSkyBlue").getColor(255));
        if (contentPane instanceof JPanel) {
            JPanel p = (JPanel)contentPane;
            p.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CConnectDialog.this.mNodeClient.dismissDialog();
            }
        });
        JLabel labelAddress = this.createLabel("Node Address (IP:Port):");
        contentPane.add((Component)labelAddress, "gap 0");
        this.mComboAddress = this.createComboAddress();
        labelAddress.setLabelFor(this.mComboAddress);
        contentPane.add(this.mComboAddress);
        JLabel labelUserId = this.createLabel("User ID:");
        contentPane.add((Component)labelUserId, "gap 0");
        this.mTextFieldUserId = this.createTextFieldUserId();
        labelUserId.setLabelFor(this.mTextFieldUserId);
        contentPane.add(this.mTextFieldUserId);
        JLabel labelPassword = this.createLabel("Password:");
        contentPane.add((Component)labelPassword, "gap 0");
        this.mPasswordField = this.createPasswordField();
        labelPassword.setLabelFor(this.mPasswordField);
        contentPane.add(this.mPasswordField);
        this.mLabelHint = new JLabel("");
        this.mLabelHint.setVisible(false);
        contentPane.add((Component)this.mLabelHint, "span 2, split 4");
        this.mProgress = this.createProgressBar();
        contentPane.add(this.mProgress);
        this.addButtons(contentPane);
        JRootPane rootPane = SwingUtilities.getRootPane(this.mButtonOkay);
        if (rootPane != null) {
            rootPane.setDefaultButton(this.mButtonOkay);
        }
        this.readPreferences();
        this.pack();
        if (CUtilString.isValid((String)this.mTextFieldUserId.getText())) {
            this.mPasswordField.requestFocus();
        }
        this.setLocationRelativeTo(null);
    }

    private void addButtons(@NotNull Container aContentPane) {
        this.mButtonCancel = new JButton("Quit");
        this.mButtonCancel.setBorder((Border)this.mBubbleBorder);
        this.mButtonCancel.addActionListener(this::onButtonCancel);
        aContentPane.add((Component)this.mButtonCancel, "tag cancel");
        this.mButtonOkay = new JButton("Connect");
        this.mButtonOkay.setBorder((Border)this.mBubbleBorder);
        this.mButtonOkay.addActionListener(this::onButtonOkay);
        aContentPane.add((Component)this.mButtonOkay, "tag ok");
    }

    private void onButtonOkay(ActionEvent e) {
        switch (this.mNodeClient.getStatus()) {
            case NOTHING: {
                String nodeAddress = (String)this.mComboAddress.getSelectedItem();
                if (CUtilString.isEmpty((String)nodeAddress)) {
                    this.mLabelHint.setText("Please check Node Address");
                    this.mLabelHint.setVisible(true);
                    break;
                }
                String userId = this.mTextFieldUserId.getText();
                if (CUtilString.isEmpty((String)userId)) {
                    this.mLabelHint.setText("Please check User ID");
                    this.mLabelHint.setVisible(true);
                    break;
                }
                this.writePreferences();
                String pw = this.getPassword();
                if (pw == null) break;
                this.mNodeClient.doConnect(nodeAddress, userId, pw);
                break;
            }
            case LOGIN_ERROR: {
                String userId = this.mTextFieldUserId.getText();
                if (CUtilString.isEmpty((String)userId)) {
                    this.mLabelHint.setText("Please check User ID");
                    this.mLabelHint.setVisible(true);
                    break;
                }
                this.writePreferences();
                String pw = this.getPassword();
                if (pw == null) break;
                try {
                    this.mNodeClient.login(userId, pw);
                    break;
                }
                catch (CException aE) {
                    LOG.error((Throwable)aE, "Error on LogIn.");
                }
            }
        }
    }

    private String getPassword() {
        return CUtilPassword.hashPassword((char[])this.mPasswordField.getPassword());
    }

    private void onButtonCancel(ActionEvent e) {
        EStatus status = this.mNodeClient.getStatus();
        switch (status) {
            case CONNECTING: {
                this.mNodeClient.notifyConnectCanceled();
                this.mLabelHint.setVisible(false);
                this.mProgress.setVisible(false);
                break;
            }
            case NOTHING: {
                this.mNodeClient.dismissDialog();
                break;
            }
            case CONNECTED: 
            case LOGIN: 
            case LOGGED_IN: {
                this.mNodeClient.disconnect();
                break;
            }
            case LOGIN_ERROR: {
                System.exit(0);
            }
        }
    }

    @NotNull
    private JProgressBar createProgressBar() {
        JProgressBar p = new JProgressBar(0, 0, 5000);
        p.setValue(0);
        p.setVisible(false);
        return p;
    }

    @NotNull
    private JPasswordField createPasswordField() {
        JPasswordField pw = new JPasswordField();
        pw.setFont(FONT_EDIT);
        pw.setColumns(40);
        pw.setBorder((Border)this.mBubbleBorder);
        return pw;
    }

    @NotNull
    private JLabel createLabel(@NotNull String aText) {
        JLabel label = new JLabel(aText);
        label.setFont(FONT_LABEL);
        return label;
    }

    @NotNull
    private JTextField createTextFieldUserId() {
        JTextField tf = new JTextField();
        tf.setFont(FONT_EDIT);
        tf.setColumns(40);
        tf.setBorder((Border)this.mBubbleBorder);
        return tf;
    }

    @NotNull
    private JComboBox<String> createComboAddress() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setFont(FONT_EDIT);
        combo.setEditable(true);
        combo.setBorder((Border)this.mBubbleBorder);
        for (int i = 0; i < combo.getComponentCount(); ++i) {
            JComponent component;
            if (combo.getComponent(i) instanceof AbstractButton) {
                component = (AbstractButton)combo.getComponent(i);
                component.setBorder((Border)this.mBubbleBorder);
                continue;
            }
            if (!(combo.getComponent(i) instanceof JComponent)) continue;
            component = (JComponent)combo.getComponent(i);
            component.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        Dimension ps = combo.getPreferredSize();
        ps.width = 300;
        combo.setPreferredSize(ps);
        return combo;
    }

    public void setRetryTimeout(int aTimeout, int aElapsed, int aCounter) {
        this.mLabelHint.setText("Connection attempt " + aCounter + ":");
        this.mLabelHint.setVisible(true);
        this.mProgress.setValue(aElapsed);
        this.mProgress.setMinimum(0);
        this.mProgress.setMaximum(aTimeout);
        this.mProgress.setVisible(true);
    }

    private void readPreferences() {
        Preferences pref = this.mDependencies.getKernelConfiguration().getPreferences("clientNode");
        String s = pref.get("LastNodeAddresses", "").trim();
        if (CUtilString.isValid((String)s)) {
            List list = CUtilStringArray.fromObject((Object)s);
            for (String s1 : list) {
                this.mComboAddress.addItem(s1);
            }
        } else {
            this.mComboAddress.addItem("localhost:10001");
        }
        s = pref.get("LastNodeAddress", "").trim();
        if (CUtilString.isValid((String)s)) {
            this.mComboAddress.setSelectedItem(s);
        }
        s = pref.get("LastUserId", "").trim();
        this.mTextFieldUserId.setText(s);
    }

    private void writePreferences() {
        Preferences pref = this.mDependencies.getKernelConfiguration().getPreferences("clientNode");
        String selectedItem = (String)this.mComboAddress.getSelectedItem();
        if (CUtilString.isValid((String)selectedItem)) {
            pref.put("LastNodeAddress", selectedItem);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.mComboAddress.getItemCount(); ++i) {
            String s = this.mComboAddress.getItemAt(i).trim();
            if (!CUtilString.isValid((String)s)) continue;
            list.add(s);
        }
        if (!list.contains(selectedItem)) {
            list.add(selectedItem);
        }
        String ss = CUtilStringArray.toString(list, (char)',');
        pref.put("LastNodeAddresses", ss);
        pref.put("LastUserId", this.mTextFieldUserId.getText());
    }

    public void updateStatus(@NotNull EStatus aStatus) {
        switch (aStatus) {
            case NOTHING: {
                this.mLabelHint.setVisible(false);
                this.mButtonOkay.setText("Connect");
                this.mButtonOkay.setEnabled(true);
                this.mButtonCancel.setText("Quit");
                this.mButtonCancel.setEnabled(true);
                this.mComboAddress.setEnabled(true);
                break;
            }
            case CONNECTING: {
                this.mLabelHint.setText("Connecting...");
                this.mLabelHint.setVisible(true);
                this.mButtonOkay.setEnabled(false);
                this.mButtonOkay.setText("(Connection running)");
                this.mButtonCancel.setText("Cancel");
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(false);
                this.mPasswordField.setEnabled(false);
                break;
            }
            case CONNECTED: {
                this.mLabelHint.setText("Connected.");
                this.mLabelHint.setVisible(true);
                this.mButtonCancel.setText("Disconnect");
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(false);
                this.mPasswordField.setEnabled(false);
                break;
            }
            case LOGIN: {
                this.mLabelHint.setText("LogIn...");
                this.mLabelHint.setVisible(true);
                this.mButtonCancel.setText("Cancel");
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(false);
                this.mPasswordField.setEnabled(false);
                break;
            }
            case LOGIN_PENDING: {
                this.mLabelHint.setText("Waiting for MicroServiceRegistry...");
                this.mLabelHint.setVisible(true);
                this.mButtonCancel.setText("Cancel");
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(false);
                this.mPasswordField.setEnabled(false);
                break;
            }
            case LOGGED_IN: {
                this.mLabelHint.setText("Logged in.");
                this.mLabelHint.setVisible(true);
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(false);
                this.mPasswordField.setEnabled(false);
                break;
            }
            case DISCONNECTING: {
                this.mButtonOkay.setEnabled(false);
                this.mButtonOkay.setText("(Disconnecting)");
                this.mButtonCancel.setEnabled(false);
                this.mComboAddress.setEnabled(true);
                break;
            }
            case LOGIN_ERROR: {
                this.mLabelHint.setText("User unknown or Password wrong.");
                this.mLabelHint.setVisible(true);
                this.mButtonCancel.setText("Quit");
                this.mButtonOkay.setEnabled(true);
                this.mButtonOkay.setText("LogIn");
                this.mComboAddress.setEnabled(false);
                this.mTextFieldUserId.setEnabled(true);
                this.mPasswordField.setEnabled(true);
                break;
            }
        }
    }
}

