/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.service;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreGetChunk;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CDeliverChunkHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDeliverChunkHandler.class);
    private final IFileStore mFileStore;

    CDeliverChunkHandler(@NotNull IFileStore aFileStore) {
        this.mFileStore = aFileStore;
    }

    void processRequestChunk(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String hash = CRecordFileStoreGetChunk.getHash(aRecord, null);
        CUtilCheck.checkArgument((Object)hash, (String)"Hash");
        CFileEntry entry = this.mFileStore.getFileEntryByHash(hash);
        CUtilCheck.checkNotNullEx((Object)entry, (String)"File not found", (Object[])new Object[0]);
        long pos = CRecordFileStoreGetChunk.getChunkPosition(aRecord, -1L);
        CUtilCheck.checkTrueEx((pos >= 0L && pos < entry.getFileLength() ? 1 : 0) != 0, (String)"Position invalid", (Object[])new Object[0]);
        int length = CRecordFileStoreGetChunk.getChunkLength(aRecord, -1);
        CUtilCheck.checkTrueEx((length >= 0 && pos + (long)length <= entry.getFileLength() ? 1 : 0) != 0, (String)"Length invalid", (Object[])new Object[0]);
        LOG.debug("Get Chunk from file {}: {} bytes at pos {}", new Object[]{hash, length, pos});
        Path basePath = this.mFileStore.getDirectoryForIndexedFiles();
        byte[] bytes = basePath != null ? this.readChunk(basePath, entry.getRelativePath(), entry.getHash(), pos, length) : entry.getChunkFromMemory(pos, length);
        CRecordFileStoreGetChunk.setBytes(aRecord, bytes);
        aEnvelope.setResultSuccess();
    }

    private byte[] readChunk(@NotNull Path aDirectory, @NotNull String aRelativePath, @Nullable String aHash, long aFilePosition, int aChunkLength) throws CException {
        File file = CUtilFileStore.getFile(aDirectory, aRelativePath, false, aHash);
        return CUtilFile.readChunk((File)file, (long)aFilePosition, (int)aChunkLength);
    }
}

