/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.database;

import de.sillysky.nyssr.database.IHandleResult;
import de.sillysky.nyssr.database.IPrepareStatement;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CH2Table {
    private final ILogger mLogger;
    private final String mName;
    private final Connection mConnection;
    private final CStopWatch mWatch = new CStopWatch();

    protected CH2Table(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        this.mConnection = aConnection;
        this.mLogger = aLogger;
        this.mName = aName;
    }

    protected boolean existTable(@NotNull String aTableName) {
        try {
            ResultSet rs = this.mConnection.getMetaData().getTables("USERDB", "PUBLIC", aTableName, null);
            if (rs != null) {
                return rs.next();
            }
        }
        catch (SQLException aE) {
            aE.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T executeQuery(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep, @Nullable IHandleResult<T> aResultHandler) {
        block21: {
            this.mWatch.start();
            try {
                T t;
                try (PreparedStatement statement = this.mConnection.prepareStatement(aSql);){
                    if (aPrep != null) {
                        aPrep.prepare(statement);
                    }
                    ResultSet rs = statement.executeQuery();
                    if (aResultHandler == null) break block21;
                    t = aResultHandler.handleResult(rs);
                }
                return t;
            }
            catch (SQLException e) {
                this.mLogger.error((Throwable)e, "Error {}.{}: ", new Object[]{this.mName, aName});
            }
            finally {
                this.mWatch.stop();
            }
        }
        return null;
    }

    protected long executeQueryLong(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        Long result = this.executeQuery(aSql, aName, aPrep, rs -> rs != null && rs.next() ? rs.getLong(1) : 0L);
        return result == null ? 0L : result;
    }

    @Nullable
    protected String executeQueryString(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        return this.executeQuery(aSql, aName, aPrep, rs -> rs.next() ? rs.getString(1) : null);
    }

    @Nullable
    protected List<String> executeQueryStringList(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        return this.executeQuery(aSql, aName, aPrep, rs -> {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            return list;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int executeUpdate(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        this.mWatch.start();
        try {
            int n;
            Throwable throwable;
            PreparedStatement statement;
            block18: {
                block19: {
                    statement = this.mConnection.prepareStatement(aSql);
                    throwable = null;
                    if (aPrep != null) {
                        aPrep.prepare(statement);
                    }
                    n = statement.executeUpdate();
                    if (statement == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                statement.close();
            }
            return n;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                statement.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (SQLException e) {
                    this.mLogger.error((Throwable)e, "Error {}: ", new Object[]{aName});
                }
            }
        }
        finally {
            this.mWatch.stop();
        }
        return -1;
    }

    public void printStat(@NotNull ILogger aLogger) {
        aLogger.debug("Time used: {}: {} ns", new Object[]{this.mName, this.mWatch.getAccumulatedTime()});
    }

    public String createInClause(@NotNull Collection<String> aList) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("IN (");
        boolean once = false;
        for (String s : aList) {
            if (once) {
                sb.append(',');
            } else {
                once = true;
            }
            sb.append('\'');
            sb.append(s);
            sb.append('\'');
        }
        sb.append(')');
        return sb.toString();
    }
}

