/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.connection;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.tcp.connection.CTcpConnection;
import de.sillysky.nyssr.impl.tcp.connection.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.stream.hook.IStreamHook;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.tcp.ITcpConnection;
import de.sillysky.nyssr.tcp.ITcpConnectionFactory;
import de.sillysky.nyssr.tcp.ITcpConnectionOwner;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

final class CTcpConnectionFactory
implements ITcpConnectionFactory,
IService {
    private final IDependencies mDependencies;
    private INamespace mNamespace;

    public CTcpConnectionFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mNamespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TCP, "TCP");
        aServiceRegistry.registerService(ITcpConnectionFactory.class, (Object)this);
    }

    @Override
    @NotNull
    public ITcpConnection createConnection(@NotNull ITcpConnectionOwner aOwner, @NotNull Socket aSocket, int aInputBufferSize, boolean aIsIncomingConnection) throws Exception {
        IStreamHook streamHook = this.mDependencies.getStreamHookFactory().createStreamHook();
        CTcpConnection conn = new CTcpConnection(this.mDependencies);
        conn.activate(this.mNamespace, streamHook);
        conn.initialize(aOwner, aSocket, aInputBufferSize, aIsIncomingConnection);
        return conn;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deleteConnection(ITcpConnection aConnection) {
        if (aConnection != null) {
            ((CTcpConnection)aConnection).deactivate();
        }
    }
}

