/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.link.cost.collector.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordBroadcastLinkCosts
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"933d39b7-d64a-47c9-bceb-83e41a3d2221");
    public static final String NAME = "BroadcastLinkCosts";
    public static final String DESCRIPTION = "Broadcast of Link Costs.";
    public static final String SLOT_CONNECTION_IDS = "1";
    public static final String SLOT_COSTS = "2";
    public static final String SLOT_TIME = "3";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID[] getConnectionIds(@NotNull CRecord aRecord, UUID[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_IDS);
        if (slot == null) {
            return aDefault;
        }
        return (UUID[])slot.getValue();
    }

    public static int[] getCosts(@NotNull CRecord aRecord, int[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COSTS);
        if (slot == null) {
            return aDefault;
        }
        return (int[])slot.getValue();
    }

    public static ZonedDateTime[] getTime(@NotNull CRecord aRecord, ZonedDateTime[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME);
        if (slot == null) {
            return aDefault;
        }
        return (ZonedDateTime[])slot.getValue();
    }

    public static void setConnectionIds(@NotNull CRecord aRecord, UUID[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_IDS, slot);
    }

    public static void setCosts(@NotNull CRecord aRecord, int[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_COSTS, slot);
    }

    public static void setTime(@NotNull CRecord aRecord, ZonedDateTime[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ZONED_DATE_TIME_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_TIME, slot);
    }
}

