/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.preferences.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.configuration.files.records.CRecordAddPreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreference;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordGetPreference;
import de.sillysky.nyssr.configuration.files.records.CRecordGetPreferenceList;
import de.sillysky.nyssr.configuration.files.records.CRecordSetPreference;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.kernel.config.preferences.manager.CWorkingTarget;
import de.sillysky.nyssr.impl.kernel.config.preferences.manager.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CPreferenceManager
extends CTarget
implements IService {
    private final IDependencies mDependencies;

    CPreferenceManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSetPreference.ID, this::asyncAddPreference);
        this.addMessageHandler(CRecordDeletePreference.ID, this::asyncDeletePreference);
        this.addMessageHandler(CRecordGetPreferenceList.ID, this::asyncGetNodePreferencesList);
        this.addMessageHandler(CRecordGetPreference.ID, this::asyncGetPreference);
        this.addMessageHandler(CRecordAddPreferenceNode.ID, this::asyncAddPreferenceNode);
        this.addMessageHandler(CRecordDeletePreferenceNode.ID, this::asyncDeletePreferenceNode);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getSystemNamespace().getTargetRegistry().registerTarget(this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        INanoServiceRegistry nsr = this.mDependencies.getSystemNamespace().getNanoServiceRegistry();
        nsr.addNanoServiceAndObserver(CRecordAddPreferenceNode.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordSetPreference.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordDeletePreference.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordGetPreferenceList.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordGetPreference.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordDeletePreferenceNode.class, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddPreference(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddPreferenceNode(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeletePreference(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeletePreferenceNode(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetNodePreferencesList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetPreference(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }
}

