/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.jsonio.basic.CUtilJsonHash;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.hash.CHash;
import de.sillysky.nyssr.util.hash.CHashFactory;
import de.sillysky.nyssr.util.hash.IDigest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotHash
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final IDigest mValue;

    CSlotHash() {
        this.mValue = CHashFactory.createEmpty();
    }

    private CSlotHash(@Nullable IDigest aValue) {
        this.mValue = aValue == null ? CHashFactory.createEmpty() : aValue.copy();
    }

    @NotNull
    private static CSlotHash fromObject(@Nullable Object aValue) {
        if (aValue instanceof IDigest) {
            return new CSlotHash((IDigest)aValue);
        }
        if (aValue instanceof String) {
            return CSlotHash.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotHash.fromList((List)aValue);
        }
        return new CSlotHash();
    }

    @NotNull
    private static CSlotHash fromList(@NotNull List<?> aValue) {
        IDigest value = CHashFactory.fromList(aValue);
        return new CSlotHash(value);
    }

    @NotNull
    private static CSlotHash fromStream(@NotNull DataInput aStream) throws IOException {
        IDigest value = CHashFactory.fromStream(aStream);
        return new CSlotHash(value);
    }

    @NotNull
    private static CSlotHash fromString(@NotNull String aValue) {
        IDigest value = CHashFactory.fromString(aValue);
        return new CSlotHash(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotHash.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CHash hash = CUtilJsonHash.fromJson(aValue, aByteArrayStore);
        return hash == null ? null : new CSlotHash(hash);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return IDigest.class;
    }

    @Override
    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CSlotHash cSlotHash = (CSlotHash)aOther;
        return Objects.equals(this.mValue, cSlotHash.mValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.HASH;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotHash.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        this.mValue.toStream(aStream);
    }

    @NotNull
    public String toString() {
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        return this.mValue.toString();
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return CUtilJsonHash.toJson(this.mValue, aBinaries);
    }
}

