/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.CUtilTargetAddressArray;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotTargetAddressArray
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final CTargetAddress[] mValue;

    CSlotTargetAddressArray() {
        this.mValue = null;
    }

    private CSlotTargetAddressArray(CTargetAddress[] aValue) {
        this.mValue = CUtilTargetAddressArray.copy(aValue);
    }

    @NotNull
    private static CSlotTargetAddressArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof CTargetAddress[]) {
            return new CSlotTargetAddressArray((CTargetAddress[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotTargetAddressArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotTargetAddressArray.fromList((List)aValue);
        }
        return new CSlotTargetAddressArray();
    }

    @NotNull
    private static CSlotTargetAddressArray fromList(@NotNull List<?> aValue) {
        if (aValue.isEmpty()) {
            return new CSlotTargetAddressArray();
        }
        ArrayList<CTargetAddress> list = new ArrayList<CTargetAddress>();
        for (Object element : aValue) {
            if (element == null) continue;
            if (element instanceof CTargetAddress) {
                CTargetAddress e = (CTargetAddress)element;
                list.add(e);
                continue;
            }
            if (element instanceof CTargetAddress[]) {
                CTargetAddress[] ee = (CTargetAddress[])element;
                list.addAll(Arrays.asList(ee));
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            CTargetAddress ta = CTargetAddress.fromString(s);
            list.add(ta);
        }
        CTargetAddress[] arr = new CTargetAddress[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CTargetAddress element;
            arr[pos] = element = (CTargetAddress)iterator.next();
            ++pos;
        }
        return new CSlotTargetAddressArray(arr);
    }

    @NotNull
    private static CSlotTargetAddressArray fromStream(@NotNull DataInput aStream) throws IOException {
        @Nullable CTargetAddress[] value = CUtilTargetAddressArray.fromStream(aStream);
        return new CSlotTargetAddressArray(value);
    }

    @NotNull
    private static CSlotTargetAddressArray fromString(String aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return new CSlotTargetAddressArray();
        }
        String[] result = CUtilStringArray.fromString(aValue);
        if (result == null || result.length == 0) {
            return new CSlotTargetAddressArray();
        }
        CTargetAddress[] value = new CTargetAddress[result.length];
        for (int i = 0; i < result.length; ++i) {
            value[i] = CTargetAddress.fromString(result[i]);
        }
        return new CSlotTargetAddressArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotTargetAddressArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            CTargetAddress[] values = new CTargetAddress[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CTargetAddress.fromString((String)child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotTargetAddressArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotTargetAddressArray other = (CSlotTargetAddressArray)aObj;
        return Arrays.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CTargetAddress[].class;
    }

    @Override
    public ISlot copy() {
        return new CSlotTargetAddressArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.TARGET_ADDRESS_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Objects.equals(this.mValue, aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotTargetAddressArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilTargetAddressArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue.length == 0) {
            return "";
        }
        return CUtilArray.toString(0, ',', 0, index -> index >= this.mValue.length ? "\uf00bE" : CTargetAddress.valueToString(this.mValue[index]));
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (CTargetAddress ta : this.mValue) {
                arr.add(ta == null ? "" : ta.valueToString());
            }
            return arr;
        }
        return null;
    }
}

