/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.time.CUtilInstant;
import de.sillysky.nyssr.util.time.CUtilTimestamp;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSlotUtcTimestamp
implements ISlot,
ISingleSlotTypeFactory {
    private final Timestamp mValue;

    public CSlotUtcTimestamp() {
        this.mValue = null;
    }

    public CSlotUtcTimestamp(@NotNull Timestamp aTimestamp) {
        this.mValue = aTimestamp;
    }

    public CSlotUtcTimestamp(@NotNull List<?> aValue) {
        Object object = aValue.get(0);
        this.mValue = this.create(object);
    }

    public CSlotUtcTimestamp(String aValue) {
        this.mValue = this.create(aValue);
    }

    public CSlotUtcTimestamp(DataInput aStream) throws IOException {
        Instant instant = CUtilInstant.fromStream(aStream);
        this.mValue = instant == null ? null : CUtilTimestamp.fromInstant(instant);
    }

    private Timestamp create(Object aValue) {
        Timestamp result = null;
        if (aValue != null) {
            if (aValue instanceof Timestamp) {
                result = (Timestamp)aValue;
            } else if (aValue instanceof LocalDateTime) {
                result = CUtilTimestamp.fromLocalDateTime((LocalDateTime)aValue);
            } else if (aValue instanceof String) {
                result = CUtilTimestamp.fromUtcIsoString((String)aValue);
            }
        }
        return result;
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return new CSlotUtcTimestamp(this.create(aValue));
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            Timestamp timestamp = CUtilTimestamp.fromUtcIsoString((String)aValue);
            return timestamp == null ? new CSlotUtcTimestamp() : new CSlotUtcTimestamp(timestamp);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotUtcTimestamp other = (CSlotUtcTimestamp)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    public Timestamp get() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return LocalDateTime.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    public String getString() {
        if (this.mValue == null) {
            return "null";
        }
        return CUtilTimestamp.toUtcIsoString(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.UTC_TIMESTAMP;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        return this.equals(aValue);
    }

    @Override
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return new CSlotUtcTimestamp(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        Instant instant = this.mValue == null ? null : CUtilInstant.fromTimestamp(this.mValue);
        CUtilInstant.toStream(aStream, instant);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue == null) {
            return "";
        }
        return CUtilTimestamp.toUtcIsoString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return CUtilTimestamp.toUtcIsoString(this.mValue);
        }
        return null;
    }
}

