/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.CUtilUuidArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotUuidArray
implements ISlot,
ISingleSlotTypeFactory {
    private final UUID @Nullable [] mValue;

    CSlotUuidArray() {
        this.mValue = null;
    }

    private CSlotUuidArray(UUID @Nullable [] aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotUuidArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof UUID[]) {
            return new CSlotUuidArray((UUID[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotUuidArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotUuidArray.fromList((List)aValue);
        }
        return new CSlotUuidArray();
    }

    @NotNull
    private static CSlotUuidArray fromList(@NotNull List<?> aList) {
        UUID[] array = CUtilUuidArray.fromList(aList);
        return new CSlotUuidArray(array);
    }

    @NotNull
    private static CSlotUuidArray fromStream(@NotNull DataInput aStream) throws IOException {
        UUID[] array = CUtilUuidArray.fromStream(aStream);
        return new CSlotUuidArray(array);
    }

    @NotNull
    private static CSlotUuidArray fromString(@NotNull String aValue) {
        UUID[] array = CUtilUuidArray.fromString(aValue);
        return new CSlotUuidArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotUuidArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            UUID[] values = new UUID[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CUtilUuid.fromString((String)child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotUuidArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotUuidArray other = (CSlotUuidArray)aObj;
        return CUtilUuidArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return UUID[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        @Nullable UUID[] value = CUtilUuidArray.copy(this.mValue);
        return new CSlotUuidArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.UUID_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof UUID[]) {
            UUID[] bb = (UUID[])aValue;
            return CUtilUuidArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotUuidArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilUuidArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilUuidArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilUuidArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (UUID v : this.mValue) {
                arr.add(CUtilUuid.toString(v));
            }
            return arr;
        }
        return null;
    }
}

