/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.registry;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.target.ITarget;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;

final class CTargetEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetEntry.class);
    private final CTargetAddress mAddress;
    private List<CMessage> mPendingMessages = null;
    private IMessageQueue mQueue = null;
    private ITarget mTarget = null;

    CTargetEntry(CTargetAddress aAddress) {
        this.mAddress = aAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingMessage(CMessage aMessage) {
        CTargetEntry cTargetEntry = this;
        synchronized (cTargetEntry) {
            if (this.mPendingMessages == null) {
                this.mPendingMessages = new LinkedList<CMessage>();
            }
            this.mPendingMessages.add(aMessage);
            CEnvelope env = aMessage.getEnvelope();
            env.setBlocked(true);
            env.setTimeDeliver(Instant.now());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target unknown, set message to pending for some seconds: TID={}, MID={}", this.mAddress.getTID(), aMessage.getRecord().getId());
            }
        }
    }

    void deregister() {
        if (this.mTarget != null && this.mQueue != null) {
            this.mTarget = null;
            this.mQueue = null;
        }
    }

    IMessageQueue getQueue() {
        return this.mQueue;
    }

    ITarget getTarget() {
        return this.mTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingMessages() {
        if (this.mTarget != null && this.mQueue != null) {
            CTargetEntry cTargetEntry = this;
            synchronized (cTargetEntry) {
                if (this.mPendingMessages != null) {
                    for (CMessage msg : this.mPendingMessages) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Send pending message {}.", msg);
                        }
                        try {
                            this.mTarget.handleMessage(msg);
                        }
                        catch (Exception e) {
                            LOG.error(e);
                        }
                    }
                    this.mPendingMessages.clear();
                    this.mPendingMessages = null;
                }
            }
        }
    }

    void register(ITarget aTarget, IMessageQueue aQueue) {
        if (aTarget != null && aQueue != null && this.mTarget == null && this.mQueue == null) {
            this.mQueue = aQueue;
            this.mTarget = aTarget;
        }
    }

    public String toString() {
        if (this.mTarget == null) {
            return "Target is null";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.mTarget.getClass().getSimpleName());
        sb.append("=");
        sb.append(this.mAddress.toString());
        if (this.mQueue != null) {
            sb.append(" Queue=");
            sb.append(this.mQueue.getDescription());
        }
        return sb.toString();
    }
}

