/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.jsonio.basic;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.hash.CHash;
import de.sillysky.nyssr.util.hash.EHashType;
import de.sillysky.nyssr.util.hash.IDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilJsonHash {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilJsonHash.class);

    private CUtilJsonHash() {
    }

    @Nullable
    public static CHash fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        String algorithm;
        EHashType hashType;
        String s;
        byte[] bb;
        CJsonObject jo;
        int hashCode;
        if (aValue instanceof CJsonObject && (hashCode = CUtilJsonInteger.fromJson(jo = (CJsonObject)aValue, "hashCode", 0)) != 0 && (bb = aByteArrayStore.get(hashCode)) != null && (s = CUtilJsonString.fromJson(jo, "type", null)) != null && (hashType = CUtilEnum.fromString(EHashType.class, s, EHashType.EMPTY)) != EHashType.EMPTY && CUtilString.isValid(algorithm = CUtilJsonString.fromJson(jo, "algorithm", null))) {
            try {
                return new CHash(algorithm, hashType, bb);
            }
            catch (NoSuchAlgorithmException aE) {
                LOG.error((Throwable)aE, "Couldn't read Hash");
            }
        }
        return null;
    }

    @Nullable
    public static Object toJson(@Nullable IDigest aDigest, @NotNull Map<Integer, byte[]> aBinaries) {
        if (aDigest != null) {
            CJsonObject jo = new CJsonObject(true);
            byte[] bb = aDigest.getByteArray();
            int hashCode = Objects.hashCode(bb);
            jo.put("algorithm", aDigest.getAlgorithm());
            jo.put("type", aDigest.getHashType().name());
            jo.put("hashCode", hashCode);
            aBinaries.put(hashCode, bb);
            return jo;
        }
        return null;
    }
}

