/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message.queue.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetQueueInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("2da3e618-71c2-42b2-a671-15fe88b37360");
    public static final String NAME = "GetQueueInfo";
    public static final String DESCRIPTION = "Get information about a queue.";
    public static final String SLOT_EXIST = "2";
    public static final String SLOT_IS_SYNC = "4";
    public static final String SLOT_QID = "1";
    public static final String SLOT_TARGET_COUNT = "3";
    public static final String SLOT_THREAD_NAME = "6";
    public static final String SLOT_THREAD_PRIORITY = "5";
    public static final String[] NAMESPACES = new String[]{"*"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getExist(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_EXIST);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static boolean getIsSync(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_IS_SYNC);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static IId getQid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_QID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static int getTargetCount(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGET_COUNT);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static String getThreadName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static int getThreadPriority(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_PRIORITY);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static void setExist(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_EXIST, slot);
    }

    public static void setIsSync(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_IS_SYNC, slot);
    }

    public static void setQid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_QID, slot);
    }

    public static void setTargetCount(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_TARGET_COUNT, slot);
    }

    public static void setThreadName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_THREAD_NAME, slot);
    }

    public static void setThreadPriority(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_THREAD_PRIORITY, slot);
    }
}

