/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.plugin.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetPlugInList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("5ab55a6e-1bb1-41c8-b782-5d1e09aaf701");
    public static final String NAME = "GetPlugInList";
    public static final String DESCRIPTION = "Get the PlugIn list.";
    public static final String SLOT_LOADED_ONLY = "1";
    public static final String SLOT_PLUGINS = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getLoadedOnly(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOADED_ONLY);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static CRecord[] getPlugins(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLUGINS);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setLoadedOnly(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_LOADED_ONLY, slot);
    }

    public static void setPlugins(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.RECORD_ARRAY, aValue);
        aRecord.addSlot(SLOT_PLUGINS, slot);
    }
}

