/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties.hierarchical;

import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalProperty;
import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalPropertyKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHierarchicalPropertyMap {
    protected final Map<String, CHierarchicalProperty> mProperties;

    public CHierarchicalPropertyMap() {
        this.mProperties = new HashMap<String, CHierarchicalProperty>();
    }

    public CHierarchicalPropertyMap(CHierarchicalPropertyMap aOther) {
        this.mProperties = aOther.cloneProperties();
    }

    public void addAll(@NotNull CHierarchicalPropertyMap aMap) {
        for (CHierarchicalProperty p : aMap.mProperties.values()) {
            this.addChild(p);
        }
    }

    public void addAll(@NotNull Map<String, CHierarchicalProperty> aMap) {
        for (CHierarchicalProperty p : aMap.values()) {
            this.addChild(p);
        }
    }

    public void addAll(@NotNull Collection<CHierarchicalProperty> aList) {
        for (CHierarchicalProperty p : aList) {
            this.addChild(p);
        }
    }

    public CHierarchicalProperty addChild(@NotNull CHierarchicalProperty aProperty) {
        CHierarchicalProperty p = this.mProperties.get(aProperty.getKey());
        if (p != null) {
            p.setValue(aProperty.getValue());
        } else {
            p = aProperty;
            this.mProperties.put(aProperty.getKey(), aProperty);
        }
        return p;
    }

    public CHierarchicalProperty addChild(@NotNull String aKey, @Nullable String aValue) {
        CHierarchicalProperty p = this.mProperties.get(aKey);
        if (p != null) {
            p.setValue(aValue);
        } else {
            p = new CHierarchicalProperty(aKey, aValue);
            this.mProperties.put(aKey, p);
        }
        return p;
    }

    public void addChildren(@NotNull Collection<CHierarchicalProperty> aProperties) {
        for (CHierarchicalProperty p : aProperties) {
            this.addChild(p);
        }
    }

    @NotNull
    public final Map<String, CHierarchicalProperty> cloneProperties() {
        HashMap<String, CHierarchicalProperty> map = new HashMap<String, CHierarchicalProperty>();
        for (Map.Entry<String, CHierarchicalProperty> entry : this.mProperties.entrySet()) {
            CHierarchicalProperty p = new CHierarchicalProperty(entry.getValue());
            map.put(entry.getKey(), p);
        }
        return map;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CHierarchicalPropertyMap that = (CHierarchicalPropertyMap)aO;
        return this.mProperties.equals(that.mProperties);
    }

    @Nullable
    public CHierarchicalProperty findProperty(@NotNull CHierarchicalPropertyKey aKey) {
        CHierarchicalPropertyKey key = aKey.getClone();
        String localKey = key.removeFirst();
        if (CUtilString.isEmpty(localKey)) {
            return null;
        }
        CHierarchicalProperty p = this.mProperties.get(localKey);
        if (p == null) {
            return null;
        }
        if (key.isEmpty()) {
            return p;
        }
        return p.findProperty(key);
    }

    public CHierarchicalProperty getChild(String aKey) {
        return this.mProperties.get(aKey);
    }

    public Collection<CHierarchicalProperty> getChildren() {
        return new ArrayList<CHierarchicalProperty>(this.mProperties.values());
    }

    @Nullable
    public CHierarchicalProperty getOrAppend(CHierarchicalPropertyKey aKey) {
        CHierarchicalPropertyKey key = aKey.getClone();
        String localKey = key.removeFirst();
        if (CUtilString.isEmpty(localKey)) {
            return null;
        }
        CHierarchicalProperty p = this.mProperties.get(localKey);
        if (p == null) {
            p = new CHierarchicalProperty(localKey);
            this.mProperties.put(localKey, p);
        }
        if (key.isEmpty()) {
            return p;
        }
        return p.getOrAppend(key);
    }

    @Nullable
    public String getValue(@NotNull CHierarchicalPropertyKey aKey, @Nullable String aDefault) {
        CHierarchicalProperty p = this.findProperty(aKey);
        return p == null ? aDefault : p.getValue();
    }

    public String getValue(@NotNull String aKey) {
        return this.getValue(new CHierarchicalPropertyKey(aKey), null);
    }

    public String getValue(@NotNull String aKey, @Nullable String aDefault) {
        return this.getValue(new CHierarchicalPropertyKey(aKey), aDefault);
    }

    public int hashCode() {
        return this.mProperties.hashCode();
    }

    public void mergeChildren(@NotNull Collection<CHierarchicalProperty> aProperties) {
        this.mergeChildren(this, aProperties);
    }

    private void mergeChildren(@NotNull CHierarchicalPropertyMap aBase, @NotNull Collection<CHierarchicalProperty> aProperties) {
        for (CHierarchicalProperty p : aProperties) {
            CHierarchicalProperty myChild = aBase.getChild(p.getKey());
            if (myChild == null) {
                aBase.addChild(p);
                continue;
            }
            this.mergeChildren(myChild, p.getChildren());
        }
    }

    public CHierarchicalProperty removeProperty(@NotNull String aKey) {
        return this.mProperties.remove(aKey);
    }

    public int size() {
        return this.mProperties.size();
    }

    public CStringProperties toStringProperties() {
        CStringProperties sp = new CStringProperties();
        this.toStringProperties(new CHierarchicalPropertyKey(), sp);
        return sp;
    }

    void toStringProperties(@NotNull CHierarchicalPropertyKey aParentKey, @NotNull CStringProperties aSp) {
        for (CHierarchicalProperty p : this.mProperties.values()) {
            CHierarchicalPropertyKey key = aParentKey.getClone();
            key.add(p.getKey());
            String value = p.getValue();
            aSp.put(key.toString(), value == null ? "" : value);
            p.toStringProperties(key, aSp);
        }
    }
}

