/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.dialog.monitor;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.util.CUtilString;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CDialogEntry {
    private final UUID mId;
    private final String mSearchId;
    private final String mDescription;
    private final String mSearchDescription;
    private final CTargetAddress mAddress;
    private final String mSearchAddress;
    private final CTargetAddress mClientContextAddress;
    private final LocalDateTime mStarted;

    CDialogEntry(@NotNull UUID aId, @NotNull String aDescription, @NotNull CTargetAddress aAddress, CTargetAddress aClientContextAddress) {
        this.mId = aId;
        this.mSearchId = this.mId.toString().toLowerCase();
        this.mDescription = aDescription;
        this.mSearchDescription = this.mDescription.toLowerCase();
        this.mStarted = LocalDateTime.now();
        this.mAddress = aAddress;
        this.mSearchAddress = this.mAddress.toString().toLowerCase();
        this.mClientContextAddress = aClientContextAddress;
    }

    @NotNull
    UUID getId() {
        return this.mId;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @NotNull
    public CTargetAddress getAddress() {
        return this.mAddress;
    }

    CTargetAddress getClientContextAddress() {
        return this.mClientContextAddress;
    }

    LocalDateTime getStarted() {
        return this.mStarted;
    }

    public String toString() {
        return this.mId + " (" + this.mDescription + ") at " + this.mAddress.getNodeAddress() + ", started " + this.mStarted;
    }

    public boolean match(@Nullable String aSearchString) {
        if (CUtilString.isEmpty((String)aSearchString)) {
            return true;
        }
        if (this.mSearchDescription.contains(aSearchString)) {
            return true;
        }
        if (this.mSearchId.contains(aSearchString)) {
            return true;
        }
        return this.mSearchAddress.contains(aSearchString);
    }
}

