/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreAddLocalFile
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"e62b8dea-1596-415a-b054-3fb15fd4d354");
    public static final String NAME = "FileStoreAddLocalFile";
    public static final String DESCRIPTION = "Add a local file to the file store.";
    public static final String SLOT_PATH = "1";
    public static final String SLOT_RELATIVE_DESTINATION_PATH = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getRelativeDestinationPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RELATIVE_DESTINATION_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }

    public static void setRelativeDestinationPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_RELATIVE_DESTINATION_PATH, slot);
    }
}

