/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreRequestFile
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"0b85e177-500e-47dc-b794-4675e0985d94");
    public static final String NAME = "FileStoreRequestFile";
    public static final String DESCRIPTION = "Request a file from the local file store.";
    public static final String SLOT_BYTES = "ba";
    public static final String SLOT_DELIVERY_TYPE = "how";
    public static final String SLOT_FILE = "file";
    public static final String SLOT_FILE_RECORD = "rec";
    public static final String SLOT_HASH = "hash";
    public static final String SLOT_PATH = "path";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static byte[] getBytes(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_BYTES);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static byte getDeliveryType(@NotNull CRecord aRecord, byte aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DELIVERY_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (Byte)slot.getValue();
    }

    public static Object getFile(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static CRecord getFileRecord(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE_RECORD);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static String getHash(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HASH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setBytes(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_BYTES, slot);
    }

    public static void setDeliveryType(@NotNull CRecord aRecord, byte aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE, (Object)aValue);
        aRecord.addSlot(SLOT_DELIVERY_TYPE, slot);
    }

    public static void setFile(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.OBJECT, (Object)aValue);
        aRecord.addSlot(SLOT_FILE, slot);
    }

    public static void setFileRecord(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_FILE_RECORD, slot);
    }

    public static void setHash(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HASH, slot);
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }
}

